/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.render;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public final class RenderHelper {
    public static final double RENDER_OFFSET = 9.765625E-4;
    public static final ResourceLocation MC_BLOCK_SHEET = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation MC_ITEM_SHEET = new ResourceLocation("textures/atlas/items.png");
    public static final ResourceLocation MC_FONT_DEFAULT = new ResourceLocation("textures/font/ascii.png");
    public static final ResourceLocation MC_FONT_ALTERNATE = new ResourceLocation("textures/font/ascii_sga.png");
    public static final ResourceLocation MC_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    private RenderHelper() {
    }

    public static final TextureManager engine() {
        return Minecraft.getMinecraft().renderEngine;
    }

    public static final Tessellator tessellator() {
        return Tessellator.instance;
    }

    public static void setColor3ub(int n) {
        GL11.glColor3ub((byte)((byte)(n >> 16 & 0xFF)), (byte)((byte)(n >> 8 & 0xFF)), (byte)((byte)(n & 0xFF)));
    }

    public static void setColor4ub(int n) {
        GL11.glColor4ub((byte)((byte)(n >> 24 & 0xFF)), (byte)((byte)(n >> 16 & 0xFF)), (byte)((byte)(n >> 8 & 0xFF)), (byte)((byte)(n & 0xFF)));
    }

    public static void resetColor() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderItemAsBlock(RenderBlocks renderBlocks, ItemStack itemStack, double d, double d2, double d3) {
        RenderHelper.renderTextureAsBlock(renderBlocks, itemStack.getIconIndex(), d, d2, d3);
    }

    public static void renderTextureAsBlock(RenderBlocks renderBlocks, IIcon iIcon, double d, double d2, double d3) {
        Tessellator tessellator = Tessellator.instance;
        Block block = Blocks.stone;
        if (iIcon == null) {
            return;
        }
        renderBlocks.setRenderBoundsFromBlock(block);
        GL11.glTranslated((double)d, (double)d2, (double)d3);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderBlocks.renderFaceYNeg(block, 0.0, 0.0, 0.0, iIcon);
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderBlocks.renderFaceYPos(block, 0.0, 0.0, 0.0, iIcon);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderBlocks.renderFaceZNeg(block, 0.0, 0.0, 0.0, iIcon);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderBlocks.renderFaceZPos(block, 0.0, 0.0, 0.0, iIcon);
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderBlocks.renderFaceXNeg(block, 0.0, 0.0, 0.0, iIcon);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderBlocks.renderFaceXPos(block, 0.0, 0.0, 0.0, iIcon);
        tessellator.draw();
    }

    public static void renderBlockFace(RenderBlocks renderBlocks, IIcon iIcon, int n, double d, double d2, double d3) {
        Tessellator tessellator = Tessellator.instance;
        Block block = Blocks.stone;
        if (iIcon == null || n < 0 || n > 5) {
            return;
        }
        renderBlocks.setRenderBoundsFromBlock(block);
        GL11.glTranslated((double)d, (double)d2, (double)d3);
        tessellator.startDrawingQuads();
        switch (n) {
            case 0: {
                tessellator.setNormal(0.0f, -1.0f, 0.0f);
                renderBlocks.renderFaceYNeg(block, 0.0, 0.0, 0.0, iIcon);
                break;
            }
            case 1: {
                tessellator.setNormal(0.0f, 1.0f, 0.0f);
                renderBlocks.renderFaceYPos(block, 0.0, 0.0, 0.0, iIcon);
                break;
            }
            case 2: {
                tessellator.setNormal(0.0f, 0.0f, -1.0f);
                renderBlocks.renderFaceZNeg(block, 0.0, 0.0, 0.0, iIcon);
                break;
            }
            case 3: {
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                renderBlocks.renderFaceZPos(block, 0.0, 0.0, 0.0, iIcon);
                break;
            }
            case 4: {
                tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                renderBlocks.renderFaceXNeg(block, 0.0, 0.0, 0.0, iIcon);
                break;
            }
            case 5: {
                tessellator.setNormal(1.0f, 0.0f, 0.0f);
                renderBlocks.renderFaceXPos(block, 0.0, 0.0, 0.0, iIcon);
            }
        }
        tessellator.draw();
    }

    public static void renderItemIn2D(IIcon iIcon) {
        ItemRenderer.renderItemIn2D((Tessellator)Tessellator.instance, (float)iIcon.getMaxU(), (float)iIcon.getMinV(), (float)iIcon.getMinU(), (float)iIcon.getMaxV(), (int)iIcon.getIconWidth(), (int)iIcon.getIconHeight(), (float)0.0625f);
    }

    public static void renderIcon(IIcon iIcon, double d) {
        Tessellator.instance.startDrawingQuads();
        Tessellator.instance.addVertexWithUV(0.0, 16.0, d, (double)iIcon.getMinU(), (double)iIcon.getMaxV());
        Tessellator.instance.addVertexWithUV(16.0, 16.0, d, (double)iIcon.getMaxU(), (double)iIcon.getMaxV());
        Tessellator.instance.addVertexWithUV(16.0, 0.0, d, (double)iIcon.getMaxU(), (double)iIcon.getMinV());
        Tessellator.instance.addVertexWithUV(0.0, 0.0, d, (double)iIcon.getMinU(), (double)iIcon.getMinV());
        Tessellator.instance.draw();
    }

    public static void renderIcon(double d, double d2, double d3, IIcon iIcon, int n, int n2) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(d, d2 + (double)n2, d3, (double)iIcon.getMinU(), (double)iIcon.getMaxV());
        tessellator.addVertexWithUV(d + (double)n, d2 + (double)n2, d3, (double)iIcon.getMaxU(), (double)iIcon.getMaxV());
        tessellator.addVertexWithUV(d + (double)n, d2, d3, (double)iIcon.getMaxU(), (double)iIcon.getMinV());
        tessellator.addVertexWithUV(d, d2, d3, (double)iIcon.getMinU(), (double)iIcon.getMinV());
        tessellator.draw();
    }

    public static final IIcon getFluidTexture(Fluid fluid) {
        if (fluid == null) {
            return FluidRegistry.LAVA.getIcon();
        }
        return fluid.getIcon();
    }

    public static final IIcon getFluidTexture(FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null || fluidStack.getFluid().getIcon(fluidStack) == null) {
            return FluidRegistry.LAVA.getIcon();
        }
        return fluidStack.getFluid().getIcon(fluidStack);
    }

    public static final void bindItemTexture(ItemStack itemStack) {
        RenderHelper.engine().bindTexture(itemStack.getItemSpriteNumber() == 0 ? MC_BLOCK_SHEET : MC_ITEM_SHEET);
    }

    public static final void bindTexture(ResourceLocation resourceLocation) {
        RenderHelper.engine().bindTexture(resourceLocation);
    }

    public static final void setBlockTextureSheet() {
        RenderHelper.bindTexture(MC_BLOCK_SHEET);
    }

    public static final void setItemTextureSheet() {
        RenderHelper.bindTexture(MC_ITEM_SHEET);
    }

    public static final void setDefaultFontTextureSheet() {
        RenderHelper.bindTexture(MC_FONT_DEFAULT);
    }

    public static final void setSGAFontTextureSheet() {
        RenderHelper.bindTexture(MC_FONT_ALTERNATE);
    }

    public static final void enableGUIStandardItemLighting() {
        net.minecraft.client.renderer.RenderHelper.enableGUIStandardItemLighting();
    }
}

