/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.IInventoryManager;
import cofh.lib.util.helpers.ItemHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class InventoryManagerStandard
implements IInventoryManager {
    private final IInventory _inv;
    protected ForgeDirection _targetSide;
    protected int _cachedSize;
    protected int[] _cachedSlots = new int[0];

    public InventoryManagerStandard(IInventory iInventory, ForgeDirection forgeDirection) {
        this._inv = iInventory;
        this._targetSide = forgeDirection;
    }

    @Override
    public boolean canAddItem(ItemStack itemStack, int n) {
        return this._inv.isItemValidForSlot(n, itemStack);
    }

    @Override
    public boolean canRemoveItem(ItemStack itemStack, int n) {
        return true;
    }

    @Override
    public ItemStack addItem(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        int n = itemStack.stackSize;
        ItemStack itemStack2 = itemStack.copy();
        int[] nArray = this.getSlots();
        if (nArray == null) {
            return itemStack2;
        }
        for (int n2 : nArray) {
            ItemStack itemStack3;
            int n3 = Math.min(this._inv.getInventoryStackLimit(), itemStack.getMaxStackSize());
            ItemStack itemStack4 = this.getSlotContents(n2);
            if (itemStack4 == null) {
                itemStack3 = itemStack.copy();
                itemStack3.stackSize = Math.min(n, n3);
                if (this.canAddItem(itemStack3, n2)) {
                    n -= itemStack3.stackSize;
                    this._inv.setInventorySlotContents(n2, itemStack3);
                    this._inv.markDirty();
                }
            } else if (ItemHelper.itemsEqualWithMetadata(itemStack4, itemStack, true)) {
                itemStack3 = itemStack.copy();
                itemStack3.stackSize = Math.min(n, n3 - itemStack4.stackSize);
                if (itemStack3.stackSize > 0 && this.canAddItem(itemStack3, n2)) {
                    itemStack4.stackSize += itemStack3.stackSize;
                    n -= itemStack3.stackSize;
                    this._inv.setInventorySlotContents(n2, itemStack4);
                    this._inv.markDirty();
                }
            }
            if (n == 0) break;
        }
        itemStack2.stackSize = n;
        if (itemStack2.stackSize == 0) {
            return null;
        }
        return itemStack2;
    }

    @Override
    public ItemStack removeItem(int n) {
        if (n <= 0) {
            return null;
        }
        int[] nArray = this.getSlots();
        if (nArray == null) {
            return null;
        }
        for (int n2 : nArray) {
            ItemStack itemStack = this.getSlotContents(n2);
            if (itemStack == null || !this.canRemoveItem(itemStack, n2)) continue;
            int n3 = Math.min(itemStack.stackSize, n);
            itemStack.stackSize -= n3;
            ItemStack itemStack2 = itemStack.copy();
            itemStack2.stackSize = n3;
            if (itemStack.stackSize > 0) {
                this._inv.setInventorySlotContents(n2, itemStack);
            } else {
                this._inv.setInventorySlotContents(n2, null);
            }
            this._inv.markDirty();
            return itemStack2;
        }
        return null;
    }

    @Override
    public ItemStack removeItem(int n, ItemStack itemStack) {
        if (n <= 0) {
            return null;
        }
        int[] nArray = this.getSlots();
        if (nArray == null) {
            return null;
        }
        for (int n2 : nArray) {
            ItemStack itemStack2 = this.getSlotContents(n2);
            if (!ItemHelper.itemsEqualWithMetadata(itemStack2, itemStack, true) || !this.canRemoveItem(itemStack2, n2)) continue;
            int n3 = Math.min(itemStack2.stackSize, n);
            itemStack2.stackSize -= n3;
            ItemStack itemStack3 = itemStack2.copy();
            itemStack3.stackSize = n3;
            if (itemStack2.stackSize > 0) {
                this._inv.setInventorySlotContents(n2, itemStack2);
            } else {
                this._inv.setInventorySlotContents(n2, null);
            }
            return itemStack3;
        }
        return null;
    }

    @Override
    public ItemStack getSlotContents(int n) {
        return this._inv.getStackInSlot(n);
    }

    @Override
    public int hasItem(ItemStack itemStack) {
        int n = 0;
        for (ItemStack itemStack2 : this.getContents().values()) {
            if (!ItemHelper.itemsEqualWithMetadata(itemStack2, itemStack, true)) continue;
            n += itemStack2.stackSize;
        }
        return n;
    }

    @Override
    public int findItem(ItemStack itemStack) {
        int[] nArray = this.getSlots();
        if (nArray == null) {
            return -1;
        }
        for (int n : nArray) {
            ItemStack itemStack2 = this._inv.getStackInSlot(n);
            if (!ItemHelper.itemsEqualWithMetadata(itemStack2, itemStack, true)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public int[] getSlots() {
        if (this._inv.getSizeInventory() != this._cachedSize) {
            this._cachedSize = this._inv.getSizeInventory();
            this._cachedSlots = new int[this._cachedSize];
            for (int i = 0; i < this._cachedSize; ++i) {
                this._cachedSlots[i] = i;
            }
        }
        return this._cachedSlots;
    }

    @Override
    public Map<Integer, ItemStack> getContents() {
        HashMap<Integer, ItemStack> hashMap = new HashMap<Integer, ItemStack>();
        for (int n : this.getSlots()) {
            hashMap.put(n, this._inv.getStackInSlot(n));
        }
        return hashMap;
    }
}

