/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;

public class InventoryCraftingCustom
extends InventoryCrafting {
    public IInventory masterInv;
    public int invOffset = 0;
    public int invSize = 0;
    public final int inventoryWidth;
    public final Container eventHandler;

    public InventoryCraftingCustom(Container container, int n, int n2, IInventory iInventory, int n3) {
        super(container, n, n2);
        this.invSize = n * n2;
        this.eventHandler = container;
        this.inventoryWidth = n;
        this.invOffset = n3;
        this.masterInv = iInventory;
    }

    public int getSizeInventory() {
        return this.invSize;
    }

    public ItemStack getStackInSlot(int n) {
        return n >= this.getSizeInventory() ? null : this.masterInv.getStackInSlot(this.invOffset + n);
    }

    public ItemStack getStackInRowAndColumn(int n, int n2) {
        if (n >= 0 && n < this.inventoryWidth) {
            int n3 = n + n2 * this.inventoryWidth;
            return this.getStackInSlot(n3);
        }
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int n) {
        if (this.masterInv.getStackInSlot(this.invOffset + n) != null) {
            ItemStack itemStack = this.masterInv.getStackInSlot(this.invOffset + n);
            this.masterInv.setInventorySlotContents(this.invOffset + n, null);
            return itemStack;
        }
        return null;
    }

    public ItemStack decrStackSize(int n, int n2) {
        if (this.masterInv.getStackInSlot(this.invOffset + n) != null) {
            if (this.masterInv.getStackInSlot((int)(this.invOffset + n)).stackSize <= n2) {
                ItemStack itemStack = this.masterInv.getStackInSlot(this.invOffset + n);
                this.masterInv.setInventorySlotContents(this.invOffset + n, null);
                this.eventHandler.onCraftMatrixChanged((IInventory)this);
                return itemStack;
            }
            ItemStack itemStack = this.masterInv.getStackInSlot(this.invOffset + n).splitStack(n2);
            if (this.masterInv.getStackInSlot((int)(this.invOffset + n)).stackSize <= 0) {
                this.masterInv.setInventorySlotContents(this.invOffset + n, null);
            }
            this.eventHandler.onCraftMatrixChanged((IInventory)this);
            return itemStack;
        }
        return null;
    }

    public void setInventorySlotContents(int n, ItemStack itemStack) {
        this.masterInv.setInventorySlotContents(this.invOffset + n, itemStack);
        this.eventHandler.onCraftMatrixChanged((IInventory)this);
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int n, ItemStack itemStack) {
        return true;
    }
}

