/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.container;

import cofh.api.item.IInventoryContainerItem;
import cofh.lib.gui.container.ContainerInventoryItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class InventoryContainerItemWrapper
implements IInventory {
    private final ContainerInventoryItem container;
    private final ItemStack inventory;
    private final IInventoryContainerItem inventoryItem;
    private boolean dirty = false;

    public InventoryContainerItemWrapper(ContainerInventoryItem containerInventoryItem, ItemStack itemStack) {
        this.container = containerInventoryItem;
        this.inventory = itemStack;
        this.inventoryItem = (IInventoryContainerItem)itemStack.getItem();
        if (this.inventory.stackTagCompound == null) {
            this.inventory.setTagCompound(new NBTTagCompound());
        }
    }

    public boolean getDirty() {
        boolean bl = this.dirty;
        this.dirty = false;
        return bl;
    }

    public ItemStack getContainerStack() {
        return this.inventory;
    }

    public int getSizeInventory() {
        return this.inventoryItem.getSizeInventory(this.inventory);
    }

    public ItemStack getStackInSlot(int n) {
        if (this.inventory.stackTagCompound.getCompoundTag("Slot" + n) == null || this.inventory.stackTagCompound.getCompoundTag("Slot" + n).hasNoTags()) {
            return null;
        }
        return ItemStack.loadItemStackFromNBT((NBTTagCompound)this.inventory.stackTagCompound.getCompoundTag("Slot" + n));
    }

    public ItemStack decrStackSize(int n, int n2) {
        if (this.inventory.stackTagCompound.getCompoundTag("Slot" + n) == null || this.inventory.stackTagCompound.getCompoundTag("Slot" + n).hasNoTags()) {
            return null;
        }
        ItemStack itemStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)this.inventory.stackTagCompound.getCompoundTag("Slot" + n));
        ItemStack itemStack2 = itemStack.splitStack(n2);
        if (itemStack.stackSize <= 0) {
            this.inventory.stackTagCompound.setTag("Slot" + n, (NBTBase)new NBTTagCompound());
        } else {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            itemStack.writeToNBT(nBTTagCompound);
            this.inventory.stackTagCompound.setTag("Slot" + n, (NBTBase)nBTTagCompound);
        }
        return itemStack2;
    }

    public ItemStack getStackInSlotOnClosing(int n) {
        return null;
    }

    public void setInventorySlotContents(int n, ItemStack itemStack) {
        if (itemStack == null) {
            this.inventory.stackTagCompound.setTag("Slot" + n, (NBTBase)new NBTTagCompound());
        } else {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            itemStack.writeToNBT(nBTTagCompound);
            this.inventory.stackTagCompound.setTag("Slot" + n, (NBTBase)nBTTagCompound);
        }
    }

    public String getInventoryName() {
        return this.inventory.getDisplayName();
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
        this.dirty = true;
        this.container.onSlotChanged();
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int n, ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (itemStack.getItem() instanceof IInventoryContainerItem) {
            return ((IInventoryContainerItem)itemStack.getItem()).getSizeInventory(itemStack) <= 0;
        }
        return true;
    }
}

