/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.gui.container;

import cofh.api.core.ICustomInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CustomInventoryWrapper
implements IInventory {
    private final ItemStack[] inventory;

    public CustomInventoryWrapper(ICustomInventory iCustomInventory, int n) {
        this.inventory = iCustomInventory.getInventorySlots(0);
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int n) {
        return this.inventory[n];
    }

    public ItemStack decrStackSize(int n, int n2) {
        if (this.inventory[n] == null) {
            return null;
        }
        if (this.inventory[n].stackSize <= n2) {
            n2 = this.inventory[n].stackSize;
        }
        ItemStack itemStack = this.inventory[n].splitStack(n2);
        if (this.inventory[n].stackSize <= 0) {
            this.inventory[n] = null;
        }
        return itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int n) {
        if (this.inventory[n] == null) {
            return null;
        }
        ItemStack itemStack = this.inventory[n];
        this.inventory[n] = null;
        return itemStack;
    }

    public void setInventorySlotContents(int n, ItemStack itemStack) {
        this.inventory[n] = itemStack;
        if (itemStack != null && itemStack.stackSize > this.getInventoryStackLimit()) {
            itemStack.stackSize = this.getInventoryStackLimit();
        }
    }

    public String getInventoryName() {
        return "container.crafting";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty() {
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int n, ItemStack itemStack) {
        return true;
    }
}

