/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.vec;

import cofh.repack.codechicken.lib.math.MathHelper;
import cofh.repack.codechicken.lib.util.Copyable;
import cofh.repack.codechicken.lib.vec.BlockCoord;
import cofh.repack.codechicken.lib.vec.Quat;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Translation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public class Vector3
implements Copyable<Vector3> {
    public static Vector3 zero = new Vector3();
    public static Vector3 one = new Vector3(1.0, 1.0, 1.0);
    public static Vector3 center = new Vector3(0.5, 0.5, 0.5);
    public double x;
    public double y;
    public double z;

    public Vector3() {
    }

    public Vector3(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Vector3(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
    }

    public Vector3(double[] dArray) {
        this(dArray[0], dArray[1], dArray[2]);
    }

    public Vector3(Vec3 vec3) {
        this.x = vec3.xCoord;
        this.y = vec3.yCoord;
        this.z = vec3.zCoord;
    }

    public Vector3(BlockCoord blockCoord) {
        this.x = blockCoord.x;
        this.y = blockCoord.y;
        this.z = blockCoord.z;
    }

    @Override
    public Vector3 copy() {
        return new Vector3(this);
    }

    public static Vector3 fromEntity(Entity entity) {
        return new Vector3(entity.posX, entity.posY, entity.posZ);
    }

    public static Vector3 fromEntityCenter(Entity entity) {
        return new Vector3(entity.posX, entity.posY - (double)entity.yOffset + (double)(entity.height / 2.0f), entity.posZ);
    }

    public static Vector3 fromTileEntity(TileEntity tileEntity) {
        return new Vector3(tileEntity.xCoord, tileEntity.yCoord, tileEntity.zCoord);
    }

    public static Vector3 fromTileEntityCenter(TileEntity tileEntity) {
        return new Vector3((double)tileEntity.xCoord + 0.5, (double)tileEntity.yCoord + 0.5, (double)tileEntity.zCoord + 0.5);
    }

    public static Vector3 fromAxes(double[] dArray) {
        return new Vector3(dArray[2], dArray[0], dArray[1]);
    }

    public Vector3 set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3 set(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
        return this;
    }

    public double getSide(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return this.y;
            }
            case 2: 
            case 3: {
                return this.z;
            }
            case 4: 
            case 5: {
                return this.x;
            }
        }
        throw new IndexOutOfBoundsException("Switch Falloff");
    }

    public Vector3 setSide(int n, double d) {
        switch (n) {
            case 0: 
            case 1: {
                this.y = d;
                break;
            }
            case 2: 
            case 3: {
                this.z = d;
                break;
            }
            case 4: 
            case 5: {
                this.x = d;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Switch Falloff");
            }
        }
        return this;
    }

    public double dotProduct(Vector3 vector3) {
        double d = vector3.x * this.x + vector3.y * this.y + vector3.z * this.z;
        if (d > 1.0 && d < 1.00001) {
            d = 1.0;
        } else if (d < -1.0 && d > -1.00001) {
            d = -1.0;
        }
        return d;
    }

    public double dotProduct(double d, double d2, double d3) {
        return d * this.x + d2 * this.y + d3 * this.z;
    }

    public Vector3 crossProduct(Vector3 vector3) {
        double d = this.y * vector3.z - this.z * vector3.y;
        double d2 = this.z * vector3.x - this.x * vector3.z;
        double d3 = this.x * vector3.y - this.y * vector3.x;
        this.x = d;
        this.y = d2;
        this.z = d3;
        return this;
    }

    public Vector3 add(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
        return this;
    }

    public Vector3 add(Vector3 vector3) {
        this.x += vector3.x;
        this.y += vector3.y;
        this.z += vector3.z;
        return this;
    }

    public Vector3 add(double d) {
        return this.add(d, d, d);
    }

    public Vector3 sub(Vector3 vector3) {
        return this.subtract(vector3);
    }

    public Vector3 subtract(Vector3 vector3) {
        this.x -= vector3.x;
        this.y -= vector3.y;
        this.z -= vector3.z;
        return this;
    }

    public Vector3 negate(Vector3 vector3) {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3 multiply(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public Vector3 multiply(Vector3 vector3) {
        this.x *= vector3.x;
        this.y *= vector3.y;
        this.z *= vector3.z;
        return this;
    }

    public Vector3 multiply(double d, double d2, double d3) {
        this.x *= d;
        this.y *= d2;
        this.z *= d3;
        return this;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double magSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 normalize() {
        double d = this.mag();
        if (d != 0.0) {
            this.multiply(1.0 / d);
        }
        return this;
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "Vector3(" + new BigDecimal(this.x, mathContext) + ", " + new BigDecimal(this.y, mathContext) + ", " + new BigDecimal(this.z, mathContext) + ")";
    }

    public Vector3 perpendicular() {
        if (this.z == 0.0) {
            return this.zCrossProduct();
        }
        return this.xCrossProduct();
    }

    public Vector3 xCrossProduct() {
        double d = this.z;
        double d2 = -this.y;
        this.x = 0.0;
        this.y = d;
        this.z = d2;
        return this;
    }

    public Vector3 zCrossProduct() {
        double d = this.y;
        double d2 = -this.x;
        this.x = d;
        this.y = d2;
        this.z = 0.0;
        return this;
    }

    public Vector3 yCrossProduct() {
        double d = -this.z;
        double d2 = this.x;
        this.x = d;
        this.y = 0.0;
        this.z = d2;
        return this;
    }

    public Vector3 rotate(double d, Vector3 vector3) {
        Quat.aroundAxis(vector3.copy().normalize(), d).rotate(this);
        return this;
    }

    public Vector3 rotate(Quat quat) {
        quat.rotate(this);
        return this;
    }

    public Vec3 toVec3D() {
        return Vec3.createVectorHelper((double)this.x, (double)this.y, (double)this.z);
    }

    public double angle(Vector3 vector3) {
        return Math.acos(this.copy().normalize().dotProduct(vector3.copy().normalize()));
    }

    public boolean isZero() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public boolean isAxial() {
        return this.x == 0.0 ? this.y == 0.0 || this.z == 0.0 : this.y == 0.0 && this.z == 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public Vector3f vector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    @SideOnly(value=Side.CLIENT)
    public Vector4f vector4f() {
        return new Vector4f((float)this.x, (float)this.y, (float)this.z, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void glVertex() {
        GL11.glVertex3d((double)this.x, (double)this.y, (double)this.z);
    }

    public Vector3 YZintercept(Vector3 vector3, double d) {
        double d2 = vector3.x - this.x;
        double d3 = vector3.y - this.y;
        double d4 = vector3.z - this.z;
        if (d2 == 0.0) {
            return null;
        }
        double d5 = (d - this.x) / d2;
        if (MathHelper.between(-1.0E-5, d5, 1.0E-5)) {
            return this;
        }
        if (!MathHelper.between(0.0, d5, 1.0)) {
            return null;
        }
        this.x = d;
        this.y += d5 * d3;
        this.z += d5 * d4;
        return this;
    }

    public Vector3 XZintercept(Vector3 vector3, double d) {
        double d2 = vector3.x - this.x;
        double d3 = vector3.y - this.y;
        double d4 = vector3.z - this.z;
        if (d3 == 0.0) {
            return null;
        }
        double d5 = (d - this.y) / d3;
        if (MathHelper.between(-1.0E-5, d5, 1.0E-5)) {
            return this;
        }
        if (!MathHelper.between(0.0, d5, 1.0)) {
            return null;
        }
        this.x += d5 * d2;
        this.y = d;
        this.z += d5 * d4;
        return this;
    }

    public Vector3 XYintercept(Vector3 vector3, double d) {
        double d2 = vector3.x - this.x;
        double d3 = vector3.y - this.y;
        double d4 = vector3.z - this.z;
        if (d4 == 0.0) {
            return null;
        }
        double d5 = (d - this.z) / d4;
        if (MathHelper.between(-1.0E-5, d5, 1.0E-5)) {
            return this;
        }
        if (!MathHelper.between(0.0, d5, 1.0)) {
            return null;
        }
        this.x += d5 * d2;
        this.y += d5 * d3;
        this.z = d;
        return this;
    }

    public Vector3 negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Translation translation() {
        return new Translation(this);
    }

    public double scalarProject(Vector3 vector3) {
        double d = vector3.mag();
        return d == 0.0 ? 0.0 : this.dotProduct(vector3) / d;
    }

    public Vector3 project(Vector3 vector3) {
        double d = vector3.magSquared();
        if (d == 0.0) {
            this.set(0.0, 0.0, 0.0);
            return this;
        }
        double d2 = this.dotProduct(vector3) / d;
        this.set(vector3).multiply(d2);
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector3)) {
            return false;
        }
        Vector3 vector3 = (Vector3)object;
        return this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
    }

    public boolean equalsT(Vector3 vector3) {
        return MathHelper.between(this.x - 1.0E-5, vector3.x, this.x + 1.0E-5) && MathHelper.between(this.y - 1.0E-5, vector3.y, this.y + 1.0E-5) && MathHelper.between(this.z - 1.0E-5, vector3.z, this.z + 1.0E-5);
    }

    public Vector3 apply(Transformation transformation) {
        transformation.apply(this);
        return this;
    }

    public Vector3 $tilde() {
        return this.normalize();
    }

    public Vector3 unary_$tilde() {
        return this.normalize();
    }

    public Vector3 $plus(Vector3 vector3) {
        return this.add(vector3);
    }

    public Vector3 $minus(Vector3 vector3) {
        return this.subtract(vector3);
    }

    public Vector3 $times(double d) {
        return this.multiply(d);
    }

    public Vector3 $div(double d) {
        return this.multiply(1.0 / d);
    }

    public Vector3 $times(Vector3 vector3) {
        return this.crossProduct(vector3);
    }

    public double $dot$times(Vector3 vector3) {
        return this.dotProduct(vector3);
    }
}

