/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.colour.Colour;
import cofh.repack.codechicken.lib.colour.ColourARGB;
import cofh.repack.codechicken.lib.render.PlaceholderTexture;
import cofh.repack.codechicken.lib.render.TextureDataHolder;
import cofh.repack.codechicken.lib.render.TextureSpecial;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class TextureUtils {
    private static ArrayList<IIconSelfRegister> iconRegistrars;

    public static void addIconRegistrar(IIconSelfRegister iIconSelfRegister) {
        iconRegistrars.add(iIconSelfRegister);
    }

    @SubscribeEvent
    public void textureLoad(TextureStitchEvent.Pre pre) {
        for (IIconSelfRegister iIconSelfRegister : iconRegistrars) {
            if (iIconSelfRegister.atlasIndex() != pre.map.getTextureType()) continue;
            iIconSelfRegister.registerIcons((IIconRegister)pre.map);
        }
    }

    public static int[] loadTextureData(ResourceLocation resourceLocation) {
        return TextureUtils.loadTexture((ResourceLocation)resourceLocation).data;
    }

    public static Colour[] loadTextureColours(ResourceLocation resourceLocation) {
        int[] nArray = TextureUtils.loadTextureData(resourceLocation);
        Colour[] colourArray = new Colour[nArray.length];
        for (int i = 0; i < colourArray.length; ++i) {
            colourArray[i] = new ColourARGB(nArray[i]);
        }
        return colourArray;
    }

    public static InputStream getTextureResource(ResourceLocation resourceLocation) throws IOException {
        return Minecraft.getMinecraft().getResourceManager().getResource(resourceLocation).getInputStream();
    }

    public static BufferedImage loadBufferedImage(ResourceLocation resourceLocation) {
        try {
            return TextureUtils.loadBufferedImage(TextureUtils.getTextureResource(resourceLocation));
        }
        catch (Exception exception) {
            System.err.println("Failed to load texture file: " + resourceLocation);
            exception.printStackTrace();
            return null;
        }
    }

    public static BufferedImage loadBufferedImage(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        inputStream.close();
        return bufferedImage;
    }

    public static TextureManager engine() {
        return Minecraft.getMinecraft().renderEngine;
    }

    public static void copySubImg(int[] nArray, int n, int n2, int n3, int n4, int n5, int[] nArray2, int n6, int n7, int n8) {
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n9 = (i + n3) * n + j + n2;
                int n10 = (i + n7) * n6 + j + n7;
                nArray2[n10] = nArray[n9];
            }
        }
    }

    public static void bindAtlas(int n) {
        TextureUtils.engine().bindTexture(n == 0 ? TextureMap.locationBlocksTexture : TextureMap.locationItemsTexture);
    }

    public static IIcon getBlankIcon(int n, IIconRegister iIconRegister) {
        TextureMap textureMap = (TextureMap)iIconRegister;
        String string = "blank_" + n;
        if (textureMap.getTextureExtry(string) == null) {
            TextureSpecial textureSpecial = new TextureSpecial(string).blank(n);
            textureMap.setTextureEntry(string, (TextureAtlasSprite)textureSpecial);
        }
        return iIconRegister.registerIcon(string);
    }

    public static TextureSpecial getTextureSpecial(IIconRegister iIconRegister, String string) {
        TextureMap textureMap = (TextureMap)iIconRegister;
        TextureAtlasSprite textureAtlasSprite = textureMap.getTextureExtry(string);
        if (textureAtlasSprite != null) {
            throw new IllegalStateException("Texture: " + string + " is already registered");
        }
        TextureSpecial textureSpecial = new TextureSpecial(string);
        textureMap.setTextureEntry(string, (TextureAtlasSprite)textureSpecial);
        return textureSpecial;
    }

    public static void prepareTexture(int n, int n2, int n3, int n4) {
        GL11.glBindTexture((int)n, (int)n2);
        GL11.glTexParameteri((int)n, (int)10241, (int)n3);
        GL11.glTexParameteri((int)n, (int)10240, (int)n3);
        switch (n) {
            case 32879: {
                GL11.glTexParameteri((int)n, (int)32882, (int)n4);
            }
            case 3553: {
                GL11.glTexParameteri((int)n, (int)10243, (int)n4);
            }
            case 3552: {
                GL11.glTexParameteri((int)n, (int)10242, (int)n4);
            }
        }
    }

    public static TextureDataHolder loadTexture(ResourceLocation resourceLocation) {
        BufferedImage bufferedImage = TextureUtils.loadBufferedImage(resourceLocation);
        if (bufferedImage == null) {
            throw new RuntimeException("Texture not found: " + resourceLocation);
        }
        return new TextureDataHolder(bufferedImage);
    }

    public static boolean refreshTexture(TextureMap textureMap, String string) {
        if (textureMap.getTextureExtry(string) == null) {
            textureMap.setTextureEntry(string, (TextureAtlasSprite)new PlaceholderTexture(string));
            return true;
        }
        return false;
    }

    public static IIcon safeIcon(IIcon iIcon) {
        if (iIcon == null) {
            iIcon = ((TextureMap)Minecraft.getMinecraft().getTextureManager().getTexture(TextureMap.locationBlocksTexture)).getAtlasSprite("missingno");
        }
        return iIcon;
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new TextureUtils());
        iconRegistrars = new ArrayList();
    }

    public static interface IIconSelfRegister {
        public void registerIcons(IIconRegister var1);

        public int atlasIndex();
    }
}

