/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.render.SpriteSheetManager;
import cofh.repack.codechicken.lib.render.TextureDataHolder;
import cofh.repack.codechicken.lib.render.TextureFX;
import cofh.repack.codechicken.lib.render.TextureUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class TextureSpecial
extends TextureAtlasSprite
implements TextureUtils.IIconSelfRegister {
    private int spriteIndex;
    private SpriteSheetManager.SpriteSheet spriteSheet;
    private TextureFX textureFX;
    private int mipmapLevels;
    private int rawWidth;
    private int rawHeight;
    private int blankSize = -1;
    private ArrayList<TextureDataHolder> baseTextures;
    private boolean selfRegister;
    public int atlasIndex;

    protected TextureSpecial(String string) {
        super(string);
    }

    public TextureSpecial addTexture(TextureDataHolder textureDataHolder) {
        if (this.baseTextures == null) {
            this.baseTextures = new ArrayList();
        }
        this.baseTextures.add(textureDataHolder);
        return this;
    }

    public TextureSpecial baseFromSheet(SpriteSheetManager.SpriteSheet spriteSheet, int n) {
        this.spriteSheet = spriteSheet;
        this.spriteIndex = n;
        return this;
    }

    public TextureSpecial addTextureFX(TextureFX textureFX) {
        this.textureFX = textureFX;
        return this;
    }

    public void initSprite(int n, int n2, int n3, int n4, boolean bl) {
        super.initSprite(n, n2, n3, n4, bl);
        if (this.textureFX != null) {
            this.textureFX.onTextureDimensionsUpdate(this.rawWidth, this.rawHeight);
        }
    }

    public void updateAnimation() {
        if (this.textureFX != null) {
            this.textureFX.update();
            if (this.textureFX.changed()) {
                Object object = new int[this.mipmapLevels + 1][];
                object[0] = this.textureFX.imageData;
                object = this.prepareAnisotropicFiltering((int[][])object);
                object = TextureUtil.generateMipmapData((int)this.mipmapLevels, (int)this.width, (int[][])object);
                TextureUtil.uploadTextureMipmap((int[][])object, (int)this.width, (int)this.height, (int)this.originX, (int)this.originY, (boolean)false, (boolean)false);
            }
        }
    }

    public int[][] prepareAnisotropicFiltering(int[][] nArray) {
        if (Minecraft.getMinecraft().gameSettings.anisotropicFiltering <= 1) {
            return nArray;
        }
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            if (nArray2 == null) continue;
            int[] nArray3 = new int[(this.rawWidth + 16 >> i) * (this.rawHeight + 16 >> i)];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            nArrayArray[i] = TextureUtil.prepareAnisotropicData((int[])nArray3, (int)(this.rawWidth >> i), (int)(this.rawHeight >> i), (int)(8 >> i));
        }
        return nArrayArray;
    }

    public void loadSprite(BufferedImage[] bufferedImageArray, AnimationMetadataSection animationMetadataSection, boolean bl) {
        this.rawWidth = bufferedImageArray[0].getWidth();
        this.rawHeight = bufferedImageArray[0].getHeight();
        super.loadSprite(bufferedImageArray, animationMetadataSection, bl);
    }

    public void generateMipmaps(int n) {
        super.generateMipmaps(n);
        this.mipmapLevels = n;
    }

    public boolean hasCustomLoader(IResourceManager iResourceManager, ResourceLocation resourceLocation) {
        return true;
    }

    public void addFrame(int[] nArray, int n, int n2) {
        GameSettings gameSettings = Minecraft.getMinecraft().gameSettings;
        BufferedImage[] bufferedImageArray = new BufferedImage[gameSettings.mipmapLevels + 1];
        bufferedImageArray[0] = new BufferedImage(n, n2, 2);
        bufferedImageArray[0].setRGB(0, 0, n, n2, nArray, 0, n);
        this.loadSprite(bufferedImageArray, null, gameSettings.anisotropicFiltering > 1);
    }

    public boolean load(IResourceManager iResourceManager, ResourceLocation resourceLocation) {
        if (this.baseTextures != null) {
            for (TextureDataHolder textureDataHolder : this.baseTextures) {
                this.addFrame(textureDataHolder.data, textureDataHolder.width, textureDataHolder.height);
            }
        } else if (this.spriteSheet != null) {
            TextureDataHolder textureDataHolder = this.spriteSheet.createSprite(this.spriteIndex);
            this.addFrame(textureDataHolder.data, textureDataHolder.width, textureDataHolder.height);
        } else if (this.blankSize > 0) {
            this.addFrame(new int[this.blankSize * this.blankSize], this.blankSize, this.blankSize);
        }
        if (this.framesTextureData.isEmpty()) {
            throw new RuntimeException("No base frame for texture: " + this.getIconName());
        }
        return false;
    }

    public boolean hasAnimationMetadata() {
        return this.textureFX != null || super.hasAnimationMetadata();
    }

    public int getFrameCount() {
        if (this.textureFX != null) {
            return 1;
        }
        return super.getFrameCount();
    }

    public TextureSpecial blank(int n) {
        this.blankSize = n;
        return this;
    }

    public TextureSpecial selfRegister() {
        this.selfRegister = true;
        TextureUtils.addIconRegistrar(this);
        return this;
    }

    @Override
    public void registerIcons(IIconRegister iIconRegister) {
        if (this.selfRegister) {
            ((TextureMap)iIconRegister).setTextureEntry(this.getIconName(), (TextureAtlasSprite)this);
        }
    }

    @Override
    public int atlasIndex() {
        return this.atlasIndex;
    }
}

