/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.render.SpriteSheetManager;
import cofh.repack.codechicken.lib.render.TextureSpecial;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;

@SideOnly(value=Side.CLIENT)
public class TextureFX {
    public int[] imageData;
    public int tileSizeBase = 16;
    public int tileSizeSquare = 256;
    public int tileSizeMask = 15;
    public int tileSizeSquareMask = 255;
    public boolean anaglyphEnabled;
    public TextureSpecial texture;

    public TextureFX(int n, SpriteSheetManager.SpriteSheet spriteSheet) {
        this.texture = spriteSheet.bindTextureFX(n, this);
    }

    public TextureFX(int n, String string) {
        this.texture = new TextureSpecial(string).blank(n).selfRegister().addTextureFX(this);
    }

    public TextureFX setAtlas(int n) {
        this.texture.atlasIndex = n;
        return this;
    }

    public void setup() {
        this.imageData = new int[this.tileSizeSquare];
    }

    public void onTextureDimensionsUpdate(int n, int n2) {
        if (n != n2) {
            throw new IllegalArgumentException("Non-Square textureFX not supported (" + n + ":" + n2 + ")");
        }
        this.tileSizeBase = n;
        this.tileSizeSquare = this.tileSizeBase * this.tileSizeBase;
        this.tileSizeMask = this.tileSizeBase - 1;
        this.tileSizeSquareMask = this.tileSizeSquare - 1;
        this.setup();
    }

    public void update() {
        this.anaglyphEnabled = Minecraft.getMinecraft().gameSettings.anaglyph;
        this.onTick();
    }

    public void onTick() {
    }

    public boolean changed() {
        return true;
    }
}

