/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.repack.codechicken.lib.vec.Vector3;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class EntityDigIconFX
extends EntityFX {
    public EntityDigIconFX(World world, double d, double d2, double d3, double d4, double d5, double d6, IIcon iIcon) {
        super(world, d, d2, d3, d4, d5, d6);
        this.particleIcon = iIcon;
        this.particleGravity = 1.0f;
        this.particleBlue = 0.6f;
        this.particleGreen = 0.6f;
        this.particleRed = 0.6f;
        this.particleScale /= 2.0f;
    }

    public int getFXLayer() {
        return 1;
    }

    public void setScale(float f) {
        this.particleScale = f;
    }

    public float getScale() {
        return this.particleScale;
    }

    public void setMaxAge(int n) {
        this.particleMaxAge = n;
    }

    public int getMaxAge() {
        return this.particleMaxAge;
    }

    public void renderParticle(Tessellator tessellator, float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = ((float)this.particleTextureIndexX + this.particleTextureJitterX / 4.0f) / 16.0f;
        float f8 = f7 + 0.015609375f;
        float f9 = ((float)this.particleTextureIndexY + this.particleTextureJitterY / 4.0f) / 16.0f;
        float f10 = f9 + 0.015609375f;
        float f11 = 0.1f * this.particleScale;
        if (this.particleIcon != null) {
            f7 = this.particleIcon.getInterpolatedU((double)(this.particleTextureJitterX / 4.0f * 16.0f));
            f8 = this.particleIcon.getInterpolatedU((double)((this.particleTextureJitterX + 1.0f) / 4.0f * 16.0f));
            f9 = this.particleIcon.getInterpolatedV((double)(this.particleTextureJitterY / 4.0f * 16.0f));
            f10 = this.particleIcon.getInterpolatedV((double)((this.particleTextureJitterY + 1.0f) / 4.0f * 16.0f));
        }
        float f12 = (float)(this.prevPosX + (this.posX - this.prevPosX) * (double)f - interpPosX);
        float f13 = (float)(this.prevPosY + (this.posY - this.prevPosY) * (double)f - interpPosY);
        float f14 = (float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)f - interpPosZ);
        float f15 = 1.0f;
        tessellator.setColorOpaque_F(f15 * this.particleRed, f15 * this.particleGreen, f15 * this.particleBlue);
        tessellator.addVertexWithUV((double)(f12 - f2 * f11 - f5 * f11), (double)(f13 - f3 * f11), (double)(f14 - f4 * f11 - f6 * f11), (double)f7, (double)f10);
        tessellator.addVertexWithUV((double)(f12 - f2 * f11 + f5 * f11), (double)(f13 + f3 * f11), (double)(f14 - f4 * f11 + f6 * f11), (double)f7, (double)f9);
        tessellator.addVertexWithUV((double)(f12 + f2 * f11 + f5 * f11), (double)(f13 + f3 * f11), (double)(f14 + f4 * f11 + f6 * f11), (double)f8, (double)f9);
        tessellator.addVertexWithUV((double)(f12 + f2 * f11 - f5 * f11), (double)(f13 - f3 * f11), (double)(f14 + f4 * f11 - f6 * f11), (double)f8, (double)f10);
    }

    public static void addBlockHitEffects(World world, Cuboid6 cuboid6, int n, IIcon iIcon, EffectRenderer effectRenderer) {
        float f = 0.1f;
        Vector3 vector3 = cuboid6.max.copy().subtract(cuboid6.min).add(-2.0f * f);
        vector3.x *= world.rand.nextDouble();
        vector3.y *= world.rand.nextDouble();
        vector3.z *= world.rand.nextDouble();
        Vector3 vector32 = vector3.add(cuboid6.min).add(f);
        if (n == 0) {
            vector3.y = cuboid6.min.y - (double)f;
        }
        if (n == 1) {
            vector3.y = cuboid6.max.y + (double)f;
        }
        if (n == 2) {
            vector3.z = cuboid6.min.z - (double)f;
        }
        if (n == 3) {
            vector3.z = cuboid6.max.z + (double)f;
        }
        if (n == 4) {
            vector3.x = cuboid6.min.x - (double)f;
        }
        if (n == 5) {
            vector3.x = cuboid6.max.x + (double)f;
        }
        effectRenderer.addEffect(new EntityDigIconFX(world, vector32.x, vector32.y, vector32.z, 0.0, 0.0, 0.0, iIcon).multiplyVelocity(0.2f).multipleParticleScaleBy(0.6f));
    }

    public static void addBlockDestroyEffects(World world, Cuboid6 cuboid6, IIcon[] iIconArray, EffectRenderer effectRenderer) {
        Vector3 vector3 = cuboid6.max.copy().subtract(cuboid6.min);
        Vector3 vector32 = cuboid6.min.copy().add(cuboid6.max).multiply(0.5);
        Vector3 vector33 = vector3.copy().multiply(4.0);
        vector33.x = Math.ceil(vector33.x);
        vector33.y = Math.ceil(vector33.y);
        vector33.z = Math.ceil(vector33.z);
        int n = 0;
        while ((double)n < vector33.x) {
            int n2 = 0;
            while ((double)n2 < vector33.y) {
                int n3 = 0;
                while ((double)n3 < vector33.z) {
                    double d = cuboid6.min.x + ((double)n + 0.5) * vector3.x / vector33.x;
                    double d2 = cuboid6.min.y + ((double)n2 + 0.5) * vector3.y / vector33.y;
                    double d3 = cuboid6.min.z + ((double)n3 + 0.5) * vector3.z / vector33.z;
                    effectRenderer.addEffect((EntityFX)new EntityDigIconFX(world, d, d2, d3, d - vector32.x, d2 - vector32.y, d3 - vector32.z, iIconArray[world.rand.nextInt(iIconArray.length)]));
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }
}

