/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.render;

import cofh.repack.codechicken.lib.colour.ColourRGBA;
import cofh.repack.codechicken.lib.lighting.LC;
import cofh.repack.codechicken.lib.lighting.LightMatrix;
import cofh.repack.codechicken.lib.render.CCModel;
import cofh.repack.codechicken.lib.render.CCRenderPipeline;
import cofh.repack.codechicken.lib.render.Vertex5;
import cofh.repack.codechicken.lib.util.Copyable;
import cofh.repack.codechicken.lib.vec.Rotation;
import cofh.repack.codechicken.lib.vec.Transformation;
import cofh.repack.codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;

public class CCRenderState {
    private static int nextOperationIndex;
    private static ArrayList<VertexAttribute<?>> vertexAttributes;
    public static VertexAttribute<Vector3[]> normalAttrib;
    public static VertexAttribute<int[]> colourAttrib;
    public static VertexAttribute<int[]> lightingAttrib;
    public static VertexAttribute<int[]> sideAttrib;
    public static VertexAttribute<LC[]> lightCoordAttrib;
    public static IVertexSource model;
    public static int firstVertexIndex;
    public static int lastVertexIndex;
    public static int vertexIndex;
    public static CCRenderPipeline pipeline;
    public static int baseColour;
    public static int alphaOverride;
    public static boolean useNormals;
    public static boolean computeLighting;
    public static boolean useColour;
    public static LightMatrix lightMatrix;
    public static Vertex5 vert;
    public static boolean hasNormal;
    public static Vector3 normal;
    public static boolean hasColour;
    public static int colour;
    public static boolean hasBrightness;
    public static int brightness;
    public static int side;
    public static LC lc;

    public static int registerOperation() {
        return nextOperationIndex++;
    }

    public static int operationCount() {
        return nextOperationIndex;
    }

    private static int registerVertexAttribute(VertexAttribute<?> vertexAttribute) {
        vertexAttributes.add(vertexAttribute);
        return vertexAttributes.size() - 1;
    }

    public static VertexAttribute<?> getAttribute(int n) {
        return vertexAttributes.get(n);
    }

    public static void arrayCopy(Object object, int n, Object object2, int n2, int n3) {
        System.arraycopy(object, n, object2, n2, n3);
        if (object2 instanceof Copyable[]) {
            Object[] objectArray = (Object[])object2;
            Copyable[] copyableArray = (Copyable[])object2;
            for (int i = n2; i < n2 + n3; ++i) {
                if (copyableArray[i] == null) continue;
                objectArray[i] = copyableArray[i].copy();
            }
        }
    }

    public static <T> T copyOf(VertexAttribute<T> vertexAttribute, T t, int n) {
        T t2 = vertexAttribute.newArray(n);
        CCRenderState.arrayCopy(t, 0, t2, 0, ((Object[])t).length);
        return t2;
    }

    public static void reset() {
        model = null;
        pipeline.reset();
        hasColour = false;
        hasBrightness = false;
        hasNormal = false;
        useNormals = false;
        computeLighting = true;
        useColour = true;
        alphaOverride = -1;
        baseColour = -1;
    }

    public static void setPipeline(IVertexOperation ... iVertexOperationArray) {
        pipeline.setPipeline(iVertexOperationArray);
    }

    public static void setPipeline(IVertexSource iVertexSource, int n, int n2, IVertexOperation ... iVertexOperationArray) {
        pipeline.reset();
        CCRenderState.setModel(iVertexSource, n, n2);
        pipeline.setPipeline(iVertexOperationArray);
    }

    public static void bindModel(IVertexSource iVertexSource) {
        if (model != iVertexSource) {
            model = iVertexSource;
            pipeline.rebuild();
        }
    }

    public static void setModel(IVertexSource iVertexSource) {
        CCRenderState.setModel(iVertexSource, 0, iVertexSource.getVertices().length);
    }

    public static void setModel(IVertexSource iVertexSource, int n, int n2) {
        CCRenderState.bindModel(iVertexSource);
        CCRenderState.setVertexRange(n, n2);
    }

    public static void setVertexRange(int n, int n2) {
        firstVertexIndex = n;
        lastVertexIndex = n2;
    }

    public static void render(IVertexOperation ... iVertexOperationArray) {
        CCRenderState.setPipeline(iVertexOperationArray);
        CCRenderState.render();
    }

    public static void render() {
        Vertex5[] vertex5Array = model.getVertices();
        for (vertexIndex = firstVertexIndex; vertexIndex < lastVertexIndex; ++vertexIndex) {
            model.prepareVertex();
            vert.set(vertex5Array[vertexIndex]);
            CCRenderState.runPipeline();
            CCRenderState.writeVert();
        }
    }

    public static void runPipeline() {
        pipeline.operate();
    }

    public static void writeVert() {
        if (hasNormal) {
            Tessellator.instance.setNormal((float)CCRenderState.normal.x, (float)CCRenderState.normal.y, (float)CCRenderState.normal.z);
        }
        if (hasColour) {
            Tessellator.instance.setColorRGBA(colour >>> 24, colour >> 16 & 0xFF, colour >> 8 & 0xFF, alphaOverride >= 0 ? alphaOverride : colour & 0xFF);
        }
        if (hasBrightness) {
            Tessellator.instance.setBrightness(brightness);
        }
        Tessellator.instance.addVertexWithUV(CCRenderState.vert.vec.x, CCRenderState.vert.vec.y, CCRenderState.vert.vec.z, CCRenderState.vert.uv.u, CCRenderState.vert.uv.v);
    }

    public static void setNormal(double d, double d2, double d3) {
        hasNormal = true;
        normal.set(d, d2, d3);
    }

    public static void setNormal(Vector3 vector3) {
        hasNormal = true;
        normal.set(vector3);
    }

    public static void setColour(int n) {
        hasColour = true;
        colour = n;
    }

    public static void setBrightness(int n) {
        hasBrightness = true;
        brightness = n;
    }

    public static void setBrightness(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        CCRenderState.setBrightness(iBlockAccess.getBlock(n, n2, n3).getMixedBrightnessForBlock(iBlockAccess, n, n2, n3));
    }

    public static void pullLightmap() {
        CCRenderState.setBrightness((int)OpenGlHelper.lastBrightnessY << 16 | (int)OpenGlHelper.lastBrightnessX);
    }

    public static void pushLightmap() {
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)(brightness & 0xFFFF), (float)(brightness >>> 16));
    }

    public static void setDynamic() {
        useNormals = true;
        computeLighting = false;
    }

    public static void changeTexture(String string) {
        CCRenderState.changeTexture(new ResourceLocation(string));
    }

    public static void changeTexture(ResourceLocation resourceLocation) {
        Minecraft.getMinecraft().renderEngine.bindTexture(resourceLocation);
    }

    public static void startDrawing() {
        CCRenderState.startDrawing(7);
    }

    public static void startDrawing(int n) {
        Tessellator.instance.startDrawing(n);
        if (hasColour) {
            Tessellator.instance.setColorRGBA(colour >>> 24, colour >> 16 & 0xFF, colour >> 8 & 0xFF, alphaOverride >= 0 ? alphaOverride : colour & 0xFF);
        }
        if (hasBrightness) {
            Tessellator.instance.setBrightness(brightness);
        }
    }

    public static void draw() {
        Tessellator.instance.draw();
    }

    static /* synthetic */ int access$000(VertexAttribute vertexAttribute) {
        return CCRenderState.registerVertexAttribute(vertexAttribute);
    }

    static {
        vertexAttributes = new ArrayList();
        normalAttrib = new VertexAttribute<Vector3[]>(){
            private Vector3[] normalRef;

            @Override
            public Vector3[] newArray(int n) {
                return new Vector3[n];
            }

            @Override
            public boolean load() {
                this.normalRef = model.getAttributes(this);
                if (model.hasAttribute(this)) {
                    return this.normalRef != null;
                }
                if (model.hasAttribute(sideAttrib)) {
                    pipeline.addDependency(sideAttrib);
                    return true;
                }
                throw new IllegalStateException("Normals requested but neither normal or side attrutes are provided by the model");
            }

            @Override
            public void operate() {
                if (this.normalRef != null) {
                    CCRenderState.setNormal(this.normalRef[vertexIndex]);
                } else {
                    CCRenderState.setNormal(Rotation.axes[side]);
                }
            }
        };
        colourAttrib = new VertexAttribute<int[]>(){
            private int[] colourRef;

            @Override
            public int[] newArray(int n) {
                return new int[n];
            }

            @Override
            public boolean load() {
                this.colourRef = model.getAttributes(this);
                return this.colourRef != null || !model.hasAttribute(this);
            }

            @Override
            public void operate() {
                if (this.colourRef != null) {
                    CCRenderState.setColour(ColourRGBA.multiply(baseColour, this.colourRef[vertexIndex]));
                } else {
                    CCRenderState.setColour(baseColour);
                }
            }
        };
        lightingAttrib = new VertexAttribute<int[]>(){
            private int[] colourRef;

            @Override
            public int[] newArray(int n) {
                return new int[n];
            }

            @Override
            public boolean load() {
                if (!(computeLighting && useColour && model.hasAttribute(this))) {
                    return false;
                }
                this.colourRef = model.getAttributes(this);
                if (this.colourRef != null) {
                    pipeline.addDependency(colourAttrib);
                    return true;
                }
                return false;
            }

            @Override
            public void operate() {
                CCRenderState.setColour(ColourRGBA.multiply(colour, this.colourRef[vertexIndex]));
            }
        };
        sideAttrib = new VertexAttribute<int[]>(){
            private int[] sideRef;

            @Override
            public int[] newArray(int n) {
                return new int[n];
            }

            @Override
            public boolean load() {
                this.sideRef = model.getAttributes(this);
                if (model.hasAttribute(this)) {
                    return this.sideRef != null;
                }
                pipeline.addDependency(normalAttrib);
                return true;
            }

            @Override
            public void operate() {
                side = this.sideRef != null ? this.sideRef[vertexIndex] : CCModel.findSide(normal);
            }
        };
        lightCoordAttrib = new VertexAttribute<LC[]>(){
            private LC[] lcRef;
            private Vector3 vec = new Vector3();
            private Vector3 pos = new Vector3();

            @Override
            public LC[] newArray(int n) {
                return new LC[n];
            }

            @Override
            public boolean load() {
                this.lcRef = model.getAttributes(this);
                if (model.hasAttribute(this)) {
                    return this.lcRef != null;
                }
                this.pos.set(CCRenderState.lightMatrix.pos.x, CCRenderState.lightMatrix.pos.y, CCRenderState.lightMatrix.pos.z);
                pipeline.addDependency(sideAttrib);
                pipeline.addRequirement(Transformation.operationIndex);
                return true;
            }

            @Override
            public void operate() {
                if (this.lcRef != null) {
                    lc.set(this.lcRef[vertexIndex]);
                } else {
                    lc.compute(this.vec.set(CCRenderState.vert.vec).sub(this.pos), side);
                }
            }
        };
        pipeline = new CCRenderPipeline();
        lightMatrix = new LightMatrix();
        vert = new Vertex5();
        normal = new Vector3();
        lc = new LC();
    }

    public static interface IVertexSource {
        public Vertex5[] getVertices();

        public <T> T getAttributes(VertexAttribute<T> var1);

        public boolean hasAttribute(VertexAttribute<?> var1);

        public void prepareVertex();
    }

    public static abstract class VertexAttribute<T>
    implements IVertexOperation {
        public final int attributeIndex = CCRenderState.access$000(this);
        private final int operationIndex = CCRenderState.registerOperation();
        public boolean active = false;

        public abstract T newArray(int var1);

        @Override
        public int operationID() {
            return this.operationIndex;
        }
    }

    public static interface IVertexOperation {
        public boolean load();

        public void operate();

        public int operationID();
    }
}

