/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.lighting;

import cofh.repack.codechicken.lib.lighting.PlanarLightModel;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.vec.BlockCoord;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;

public class PlanarLightMatrix
extends PlanarLightModel {
    public static final int operationIndex = CCRenderState.registerOperation();
    public static PlanarLightMatrix instance = new PlanarLightMatrix();
    public IBlockAccess access;
    public BlockCoord pos = new BlockCoord();
    private int sampled = 0;
    public int[] brightness = new int[6];

    public PlanarLightMatrix() {
        super(PlanarLightModel.standardLightModel.colours);
    }

    public PlanarLightMatrix locate(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        this.access = iBlockAccess;
        this.pos.set(n, n2, n3);
        this.sampled = 0;
        return this;
    }

    public int brightness(int n) {
        if ((this.sampled & 1 << n) == 0) {
            Block block = this.access.getBlock(this.pos.x, this.pos.y, this.pos.z);
            this.brightness[n] = this.access.getLightBrightnessForSkyBlocks(this.pos.x, this.pos.y, this.pos.z, block.getLightValue(this.access, this.pos.x, this.pos.y, this.pos.z));
            this.sampled |= 1 << n;
        }
        return this.brightness[n];
    }

    @Override
    public boolean load() {
        CCRenderState.pipeline.addDependency(CCRenderState.sideAttrib);
        return true;
    }

    @Override
    public void operate() {
        super.operate();
        CCRenderState.setBrightness(this.brightness(CCRenderState.side));
    }

    @Override
    public int operationID() {
        return operationIndex;
    }
}

