/*
 * Decompiled with CFR 0.152.
 */
package cofh.mod.updater;

import cofh.core.CoFHProps;
import cofh.mod.updater.IUpdatableMod;
import cofh.mod.updater.ModVersion;
import cofh.mod.updater.UpdateCheckThread;
import com.google.common.base.Strings;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public final class UpdateManager {
    private static transient int pollOffset = 0;
    private static final ChatStyle description = new ChatStyle();
    private static final ChatStyle version = new ChatStyle();
    private static final ChatStyle modname = new ChatStyle();
    private static final ChatStyle download = new ChatStyle();
    private static final ChatStyle white = new ChatStyle();
    private boolean _notificationDisplayed;
    private final IUpdatableMod _mod;
    private final UpdateCheckThread _updateThread;
    private final String _downloadUrl;
    private int lastPoll = 400;

    public static void registerUpdater(UpdateManager updateManager) {
        FMLCommonHandler.instance().bus().register((Object)updateManager);
    }

    public UpdateManager(IUpdatableMod iUpdatableMod) {
        this(iUpdatableMod, null);
    }

    public UpdateManager(IUpdatableMod iUpdatableMod, String string) {
        this(iUpdatableMod, string, null);
    }

    public UpdateManager(IUpdatableMod iUpdatableMod, String string, String string2) {
        this._mod = iUpdatableMod;
        this._updateThread = new UpdateCheckThread(iUpdatableMod, string, string2);
        this._updateThread.start();
        this._downloadUrl = string2;
        this.lastPoll += (pollOffset += 140);
    }

    @SubscribeEvent
    public void tickStart(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase != TickEvent.Phase.START) {
            return;
        }
        if (MinecraftServer.getServer() != null && MinecraftServer.getServer().isServerRunning() && !MinecraftServer.getServer().getConfigurationManager().func_152596_g(playerTickEvent.player.getGameProfile())) {
            return;
        }
        if (this.lastPoll > 0) {
            --this.lastPoll;
            return;
        }
        this.lastPoll = 400;
        if (!this._notificationDisplayed && this._updateThread.checkComplete()) {
            this._notificationDisplayed = true;
            FMLCommonHandler.instance().bus().unregister((Object)this);
            if (this._updateThread.newVersionAvailable()) {
                if (!CoFHProps.enableUpdateNotice && !this._updateThread.isCriticalUpdate()) {
                    return;
                }
                ModVersion modVersion = this._updateThread.newVersion();
                EntityPlayer entityPlayer = playerTickEvent.player;
                ChatComponentText chatComponentText = new ChatComponentText("");
                ChatStyle chatStyle = modname.createShallowCopy();
                IChatComponent iChatComponent = new ChatComponentText(modVersion.modVersion().toString()).setChatStyle(version);
                chatStyle.setChatHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, iChatComponent));
                chatComponentText.appendSibling(new ChatComponentText("[" + this._mod.getModName() + "] ").setChatStyle(chatStyle));
                chatComponentText.appendSibling(new ChatComponentTranslation("info.cofh.updater.version", new Object[0]).setChatStyle(white));
                chatComponentText.appendText(EnumChatFormatting.GOLD + ":");
                entityPlayer.addChatMessage((IChatComponent)chatComponentText);
                chatComponentText = new ChatComponentText("");
                if (!Strings.isNullOrEmpty((String)this._downloadUrl)) {
                    chatComponentText.appendText(EnumChatFormatting.WHITE + "[");
                    chatStyle = download.createShallowCopy();
                    chatStyle.setChatClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this._downloadUrl));
                    chatComponentText.appendSibling(new ChatComponentTranslation("info.cofh.updater.download", new Object[0]).setChatStyle(chatStyle));
                    chatComponentText.appendText(EnumChatFormatting.WHITE + "] ");
                }
                chatComponentText.appendSibling(new ChatComponentText(modVersion.description()).setChatStyle(description));
                entityPlayer.addChatMessage((IChatComponent)chatComponentText);
            }
        }
    }

    static {
        description.setColor(EnumChatFormatting.GRAY);
        version.setColor(EnumChatFormatting.AQUA);
        modname.setColor(EnumChatFormatting.GOLD);
        download.setColor(EnumChatFormatting.GREEN);
        white.setColor(EnumChatFormatting.WHITE);
        ChatStyle chatStyle = new ChatStyle();
        chatStyle.setColor(EnumChatFormatting.YELLOW);
        IChatComponent iChatComponent = new ChatComponentTranslation("info.cofh.updater.tooltip", new Object[0]).setChatStyle(chatStyle);
        download.setChatHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, iChatComponent));
    }
}

