/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.feature;

import cofh.api.world.IFeatureGenerator;
import cofh.lib.world.biome.BiomeInfo;
import cofh.lib.world.biome.BiomeInfoSet;
import gnu.trove.set.hash.THashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class FeatureBase
implements IFeatureGenerator {
    public final String name;
    public final GenRestriction biomeRestriction;
    public final GenRestriction dimensionRestriction;
    public final boolean regen;
    protected int rarity;
    protected final BiomeInfoSet biomes = new BiomeInfoSet(1);
    protected final Set<Integer> dimensions = new THashSet();

    public FeatureBase(String string, boolean bl) {
        this(string, GenRestriction.NONE, bl, GenRestriction.NONE);
    }

    public FeatureBase(String string, boolean bl, GenRestriction genRestriction) {
        this(string, GenRestriction.NONE, bl, genRestriction);
    }

    public FeatureBase(String string, GenRestriction genRestriction, boolean bl) {
        this(string, genRestriction, bl, GenRestriction.NONE);
    }

    public FeatureBase(String string, GenRestriction genRestriction, boolean bl, GenRestriction genRestriction2) {
        this.name = string;
        this.biomeRestriction = genRestriction;
        this.dimensionRestriction = genRestriction2;
        this.regen = bl;
    }

    public void setRarity(int n) {
        this.rarity = n;
    }

    public FeatureBase addBiome(BiomeInfo biomeInfo) {
        this.biomes.add(biomeInfo);
        return this;
    }

    public FeatureBase addBiomes(BiomeInfoSet biomeInfoSet) {
        this.biomes.addAll(biomeInfoSet);
        return this;
    }

    public FeatureBase addDimension(int n) {
        this.dimensions.add(n);
        return this;
    }

    @Override
    public final String getFeatureName() {
        return this.name;
    }

    @Override
    public boolean generateFeature(Random random, int n, int n2, World world, boolean bl) {
        if (!bl && !this.regen) {
            return false;
        }
        if (this.dimensionRestriction != GenRestriction.NONE && this.dimensionRestriction == GenRestriction.BLACKLIST == this.dimensions.contains(world.provider.dimensionId)) {
            return false;
        }
        if (this.rarity > 1 && random.nextInt(this.rarity) != 0) {
            return false;
        }
        return this.generateFeature(random, n, n2, world);
    }

    protected abstract boolean generateFeature(Random var1, int var2, int var3, World var4);

    protected boolean canGenerateInBiome(World world, int n, int n2, Random random) {
        if (this.biomeRestriction != GenRestriction.NONE) {
            BiomeGenBase biomeGenBase = world.getBiomeGenForCoords(n, n2);
            return this.biomeRestriction == GenRestriction.BLACKLIST != this.biomes.contains(biomeGenBase, random);
        }
        return true;
    }

    public static enum GenRestriction {
        NONE,
        BLACKLIST,
        WHITELIST;


        public static GenRestriction get(String string) {
            if (string.equalsIgnoreCase("blacklist")) {
                return BLACKLIST;
            }
            if (string.equalsIgnoreCase("whitelist")) {
                return WHITELIST;
            }
            return NONE;
        }
    }
}

