/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenMinableCluster;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenAdvLakes
extends WorldGenerator {
    private static final List<WeightedRandomBlock> GAP_BLOCK = Arrays.asList(new WeightedRandomBlock(Blocks.air, 0));
    private final List<WeightedRandomBlock> cluster;
    private final WeightedRandomBlock[] genBlock;
    public List<WeightedRandomBlock> outlineBlock = null;
    public List<WeightedRandomBlock> gapBlock = GAP_BLOCK;
    public boolean solidOutline = false;
    public boolean totalOutline = false;
    public int width = 16;
    public int height = 8;

    public WorldGenAdvLakes(List<WeightedRandomBlock> list, List<WeightedRandomBlock> list2) {
        this.cluster = list;
        this.genBlock = list2 == null ? null : list2.toArray(new WeightedRandomBlock[list2.size()]);
    }

    public boolean generate(World world, Random random, int n, int n2, int n3) {
        int n4;
        int n5 = this.width / 2;
        n -= n5;
        n3 -= n5;
        int n6 = this.height / 2 + 1;
        while (n2 > n6 && world.isAirBlock(n, n2, n3)) {
            --n2;
        }
        if (n2 <= --n6) {
            return false;
        }
        n2 -= n6;
        boolean[] blArray = new boolean[this.width * this.width * this.height];
        int n7 = this.width - 1;
        int n8 = this.height - 1;
        int n9 = random.nextInt(4) + 4;
        for (n4 = 0; n4 < n9; ++n4) {
            double d = random.nextDouble() * 6.0 + 3.0;
            double d2 = random.nextDouble() * 4.0 + 2.0;
            double d3 = random.nextDouble() * 6.0 + 3.0;
            double d4 = random.nextDouble() * ((double)this.width - d - 2.0) + 1.0 + d / 2.0;
            double d5 = random.nextDouble() * ((double)this.height - d2 - 4.0) + 2.0 + d2 / 2.0;
            double d6 = random.nextDouble() * ((double)this.width - d3 - 2.0) + 1.0 + d3 / 2.0;
            for (int i = 1; i < n7; ++i) {
                for (int j = 1; j < n7; ++j) {
                    for (int k = 1; k < n8; ++k) {
                        double d7 = ((double)i - d4) / (d / 2.0);
                        double d8 = ((double)k - d5) / (d2 / 2.0);
                        double d9 = ((double)j - d6) / (d3 / 2.0);
                        double d10 = d7 * d7 + d8 * d8 + d9 * d9;
                        if (!(d10 < 1.0)) continue;
                        blArray[(i * this.width + j) * this.height + k] = true;
                    }
                }
            }
        }
        for (n4 = 0; n4 < this.width; ++n4) {
            for (int i = 0; i < this.width; ++i) {
                for (n9 = 0; n9 < this.height; ++n9) {
                    Material material;
                    boolean bl;
                    boolean bl2 = bl = blArray[(n4 * this.width + i) * this.height + n9] || n4 < n7 && blArray[((n4 + 1) * this.width + i) * this.height + n9] || n4 > 0 && blArray[((n4 - 1) * this.width + i) * this.height + n9] || i < n7 && blArray[(n4 * this.width + (i + 1)) * this.height + n9] || i > 0 && blArray[(n4 * this.width + (i - 1)) * this.height + n9] || n9 < n8 && blArray[(n4 * this.width + i) * this.height + (n9 + 1)] || n9 > 0 && blArray[(n4 * this.width + i) * this.height + (n9 - 1)];
                    if (!bl || !(n9 >= n6 ? (material = world.getBlock(n + n4, n2 + n9, n3 + i).getMaterial()).isLiquid() : !WorldGenMinableCluster.canGenerateInBlock(world, n + n4, n2 + n9, n3 + i, this.genBlock))) continue;
                    return false;
                }
            }
        }
        for (n4 = 0; n4 < this.width; ++n4) {
            for (int i = 0; i < this.width; ++i) {
                for (n9 = 0; n9 < this.height; ++n9) {
                    if (!blArray[(n4 * this.width + i) * this.height + n9]) continue;
                    if (n9 < n6) {
                        WorldGenMinableCluster.generateBlock(world, n + n4, n2 + n9, n3 + i, this.genBlock, this.cluster);
                        continue;
                    }
                    if (!WorldGenMinableCluster.canGenerateInBlock(world, n + n4, n2 + n9, n3 + i, this.genBlock)) continue;
                    WorldGenMinableCluster.generateBlock(world, n + n4, n2 + n9, n3 + i, this.gapBlock);
                }
            }
        }
        for (n4 = 0; n4 < this.width; ++n4) {
            for (int i = 0; i < this.width; ++i) {
                for (n9 = 0; n9 < this.height; ++n9) {
                    if (!blArray[(n4 * this.width + i) * this.height + n9] || !world.getBlock(n + n4, n2 + n9 - 1, n3 + i).equals(Blocks.dirt) || world.getSavedLightValue(EnumSkyBlock.Sky, n + n4, n2 + n9, n3 + i) <= 0) continue;
                    BiomeGenBase biomeGenBase = world.getBiomeGenForCoords(n + n4, n3 + i);
                    world.setBlock(n + n4, n2 + n9 - 1, n3 + i, biomeGenBase.topBlock, biomeGenBase.field_150604_aj, 2);
                }
            }
        }
        if (this.outlineBlock != null) {
            for (n4 = 0; n4 < this.width; ++n4) {
                for (int i = 0; i < this.width; ++i) {
                    for (n9 = 0; n9 < this.height; ++n9) {
                        boolean bl;
                        boolean bl3 = bl = !blArray[(n4 * this.width + i) * this.height + n9] && (n4 < n7 && blArray[((n4 + 1) * this.width + i) * this.height + n9] || n4 > 0 && blArray[((n4 - 1) * this.width + i) * this.height + n9] || i < n7 && blArray[(n4 * this.width + (i + 1)) * this.height + n9] || i > 0 && blArray[(n4 * this.width + (i - 1)) * this.height + n9] || n9 < n8 && blArray[(n4 * this.width + i) * this.height + (n9 + 1)] || n9 > 0 && blArray[(n4 * this.width + i) * this.height + (n9 - 1)]);
                        if (!bl || !(this.solidOutline | n9 < n6) && random.nextInt(2) == 0 || !this.totalOutline && !world.getBlock(n + n4, n2 + n9, n3 + i).getMaterial().isSolid()) continue;
                        WorldGenMinableCluster.generateBlock(world, n + n4, n2 + n9, n3 + i, this.outlineBlock);
                    }
                }
            }
        }
        return true;
    }
}

