/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.world.decoration;

import cofh.api.world.IGeneratorParser;
import cofh.core.world.FeatureParser;
import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.world.WorldGenGeode;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class GeodeParser
implements IGeneratorParser {
    @Override
    public WorldGenerator parseGenerator(String string, JsonObject jsonObject, Logger logger, List<WeightedRandomBlock> list, int n, List<WeightedRandomBlock> list2) {
        ArrayList<WeightedRandomBlock> arrayList = new ArrayList<WeightedRandomBlock>();
        if (!jsonObject.has("crust")) {
            logger.info("Entry does not specify crust for 'geode' generator. Using stone.");
            arrayList.add(new WeightedRandomBlock(Blocks.stone));
        } else if (!FeatureParser.parseResList(jsonObject.get("crust"), arrayList, true)) {
            logger.warn("Entry specifies invalid crust for 'geode' generator! Using obsidian!");
            arrayList.clear();
            arrayList.add(new WeightedRandomBlock(Blocks.obsidian));
        }
        WorldGenGeode worldGenGeode = new WorldGenGeode(list, list2, arrayList);
        if (jsonObject.has("hollow")) {
            worldGenGeode.hollow = jsonObject.get("hollow").getAsBoolean();
        }
        if (jsonObject.has("filler")) {
            arrayList = new ArrayList();
            if (!FeatureParser.parseResList(jsonObject.get("filler"), arrayList, true)) {
                logger.warn("Entry specifies invalid filler for 'geode' generator! Not filling!");
            } else {
                worldGenGeode.fillBlock = arrayList;
            }
        }
        return worldGenGeode;
    }
}

