/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.fluid;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class FluidTankAdv
implements IFluidTank {
    protected FluidStack fluid;
    protected int capacity;
    protected boolean locked;

    public FluidTankAdv(int n) {
        this(null, n);
    }

    public FluidTankAdv(FluidStack fluidStack, int n) {
        this.fluid = fluidStack;
        this.capacity = n;
    }

    public FluidTankAdv(Fluid fluid, int n, int n2) {
        this(new FluidStack(fluid, n), n2);
    }

    public FluidTankAdv readFromNBT(NBTTagCompound nBTTagCompound) {
        FluidStack fluidStack = null;
        this.locked = false;
        if (!nBTTagCompound.hasKey("Empty")) {
            fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nBTTagCompound);
            this.locked = nBTTagCompound.getBoolean("Lock") && fluidStack != null;
        }
        this.setFluid(fluidStack);
        return this;
    }

    public FluidTankAdv setLock(Fluid fluid) {
        boolean bl = this.locked = fluid != null;
        if (this.locked) {
            this.fluid = new FluidStack(fluid, 0);
        }
        return this;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nBTTagCompound) {
        if (this.fluid != null) {
            this.fluid.writeToNBT(nBTTagCompound);
            nBTTagCompound.setBoolean("Lock", this.locked);
        } else {
            nBTTagCompound.setString("Empty", "");
        }
        return nBTTagCompound;
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluid = fluidStack;
    }

    public void setCapacity(int n) {
        this.capacity = n;
    }

    public void modifyFluidStored(int n) {
        this.fluid.amount += n;
        if (this.fluid.amount > this.capacity) {
            this.fluid.amount = this.capacity;
        } else if (this.fluid.amount < 0) {
            this.fluid.amount = 0;
        }
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getFluidAmount() {
        if (this.fluid == null) {
            return 0;
        }
        return this.fluid.amount;
    }

    public int getSpace() {
        if (this.fluid == null) {
            return this.capacity;
        }
        return this.fluid.amount >= this.capacity ? 0 : this.capacity - this.fluid.amount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fillLocked(int n, boolean bl) {
        if (n <= 0 || this.fluid == null) {
            return 0;
        }
        if (!bl) {
            return Math.min(this.capacity - n, n);
        }
        int n2 = this.capacity - this.fluid.amount;
        if (n < n2) {
            this.fluid.amount += n;
            n2 = n;
        } else {
            this.fluid.amount = this.capacity;
        }
        return n2;
    }

    public int fill(FluidStack fluidStack, boolean bl) {
        if (fluidStack == null) {
            return 0;
        }
        if (!bl) {
            if (this.fluid == null) {
                return Math.min(this.capacity, fluidStack.amount);
            }
            if (!this.fluid.isFluidEqual(fluidStack)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.amount, fluidStack.amount);
        }
        if (this.fluid == null) {
            this.fluid = new FluidStack(fluidStack, Math.min(this.capacity, fluidStack.amount));
            return this.fluid.amount;
        }
        if (!this.fluid.isFluidEqual(fluidStack)) {
            return 0;
        }
        int n = this.capacity - this.fluid.amount;
        if (fluidStack.amount < n) {
            this.fluid.amount += fluidStack.amount;
            n = fluidStack.amount;
        } else {
            this.fluid.amount = this.capacity;
        }
        return n;
    }

    public FluidStack drain(int n, boolean bl) {
        if (this.fluid == null) {
            return null;
        }
        int n2 = n;
        if (this.fluid.amount < n2) {
            n2 = this.fluid.amount;
        }
        FluidStack fluidStack = new FluidStack(this.fluid, n2);
        if (bl) {
            this.fluid.amount -= n2;
            if (this.fluid.amount <= 0) {
                if (this.locked) {
                    this.fluid.amount = 0;
                } else {
                    this.fluid = null;
                }
            }
        }
        return fluidStack;
    }

    public FluidStack drain(FluidStack fluidStack, boolean bl) {
        if (fluidStack == null || !fluidStack.isFluidEqual(this.fluid)) {
            return null;
        }
        return this.drain(fluidStack.amount, bl);
    }
}

