/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.fluid;

import cofh.lib.util.BlockWrapper;
import cofh.lib.util.ItemWrapper;
import cofh.lib.util.helpers.ServerHelper;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class BucketHandler {
    public static BucketHandler instance = new BucketHandler();
    private static BiMap<BlockWrapper, ItemWrapper> buckets = HashBiMap.create();

    public static void initialize() {
    }

    private BucketHandler() {
        if (instance != null) {
            throw new IllegalArgumentException();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPreBucketFill(FillBucketEvent fillBucketEvent) {
        this.onBucketFill(fillBucketEvent, true);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPostBucketFill(FillBucketEvent fillBucketEvent) {
        this.onBucketFill(fillBucketEvent, false);
    }

    private void onBucketFill(FillBucketEvent fillBucketEvent, boolean bl) {
        ForgeDirection forgeDirection;
        if (ServerHelper.isClientWorld(fillBucketEvent.world) | fillBucketEvent.result != null || fillBucketEvent.getResult() != Event.Result.DEFAULT) {
            return;
        }
        ItemStack itemStack = fillBucketEvent.current;
        if (fillBucketEvent.target.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        boolean bl2 = true;
        int n = fillBucketEvent.target.blockX;
        int n2 = fillBucketEvent.target.blockY;
        int n3 = fillBucketEvent.target.blockZ;
        int n4 = fillBucketEvent.target.sideHit;
        if (!itemStack.getItem().equals(Items.bucket)) {
            if (FluidContainerRegistry.isBucket((ItemStack)itemStack)) {
                forgeDirection = ForgeDirection.getOrientation((int)n4);
                Block block = fillBucketEvent.world.getBlock(n, n2, n3);
                if (!block.isReplaceable((IBlockAccess)fillBucketEvent.world, n += forgeDirection.offsetX, n2 += forgeDirection.offsetY, n3 += forgeDirection.offsetZ) && block.getMaterial().isSolid()) {
                    n -= forgeDirection.offsetX;
                    n2 -= forgeDirection.offsetY;
                    n3 -= forgeDirection.offsetZ;
                }
                bl2 = false;
            } else {
                return;
            }
        }
        if (bl) {
            if (fillBucketEvent.entityPlayer != null && (!fillBucketEvent.world.canMineBlock(fillBucketEvent.entityPlayer, n, n2, n3) || bl2 && !fillBucketEvent.entityPlayer.canPlayerEdit(n, n2, n3, n4, itemStack))) {
                fillBucketEvent.setCanceled(true);
            }
            return;
        }
        forgeDirection = null;
        if (bl2) {
            forgeDirection = BucketHandler.fillBucket(fillBucketEvent.world, n, n2, n3);
        } else if (BucketHandler.emptyBucket(fillBucketEvent.world, n, n2, n3, itemStack)) {
            forgeDirection = new ItemStack(Items.bucket);
        }
        if (forgeDirection == null) {
            return;
        }
        fillBucketEvent.result = forgeDirection;
        fillBucketEvent.setResult(Event.Result.ALLOW);
    }

    public static boolean registerBucket(Block block, int n, ItemStack itemStack) {
        if (block == null || n < 0 || itemStack == null || buckets.containsKey((Object)new BlockWrapper(block, n))) {
            return false;
        }
        buckets.put((Object)new BlockWrapper(block, n), (Object)new ItemWrapper(itemStack));
        return true;
    }

    public static ItemStack fillBucket(World world, int n, int n2, int n3) {
        int n4;
        Block block = world.getBlock(n, n2, n3);
        if (!buckets.containsKey((Object)new BlockWrapper(block, n4 = world.getBlockMetadata(n, n2, n3)))) {
            IFluidBlock iFluidBlock;
            if (block.equals(Blocks.water) || block.equals(Blocks.flowing_water)) {
                if (world.getBlockMetadata(n, n2, n3) == 0) {
                    world.setBlockToAir(n, n2, n3);
                    return new ItemStack(Items.water_bucket);
                }
                return null;
            }
            if (block.equals(Blocks.lava) || block.equals(Blocks.flowing_lava)) {
                if (world.getBlockMetadata(n, n2, n3) == 0) {
                    world.setBlockToAir(n, n2, n3);
                    return new ItemStack(Items.lava_bucket);
                }
                return null;
            }
            if (block instanceof IFluidBlock && (iFluidBlock = (IFluidBlock)block).canDrain(world, n, n2, n3)) {
                ItemStack itemStack = new ItemStack(Items.bucket);
                itemStack = FluidContainerRegistry.fillFluidContainer((FluidStack)iFluidBlock.drain(world, n, n2, n3, false), (ItemStack)itemStack);
                if (itemStack != null) {
                    iFluidBlock.drain(world, n, n2, n3, true);
                    return itemStack;
                }
            }
            return null;
        }
        if (!world.setBlockToAir(n, n2, n3)) {
            return null;
        }
        ItemWrapper itemWrapper = (ItemWrapper)buckets.get((Object)new BlockWrapper(block, n4));
        return new ItemStack(itemWrapper.item, 1, itemWrapper.metadata);
    }

    public static boolean emptyBucket(World world, int n, int n2, int n3, ItemStack itemStack) {
        boolean bl;
        boolean bl2 = false;
        if (!buckets.inverse().containsKey((Object)new ItemWrapper(itemStack))) {
            if (itemStack.getItem() instanceof ItemBucket) {
                bl2 = ((ItemBucket)itemStack.getItem()).tryPlaceContainedLiquid(world, n, n2, n3);
                world.markBlockForUpdate(n, n2, n3);
            }
            return bl2;
        }
        BlockWrapper blockWrapper = (BlockWrapper)buckets.inverse().get((Object)new ItemWrapper(itemStack));
        Material material = world.getBlock(n, n2, n3).getMaterial();
        boolean bl3 = bl = !material.isSolid();
        if (world.isAirBlock(n, n2, n3) || bl) {
            if (!world.isRemote && bl && !material.isLiquid()) {
                world.func_147480_a(n, n2, n3, true);
            }
            bl2 = world.setBlock(n, n2, n3, blockWrapper.block, blockWrapper.metadata, 3);
            world.markBlockForUpdate(n, n2, n3);
        }
        return bl2;
    }

    public static void refreshMap() {
        HashBiMap hashBiMap = HashBiMap.create((int)buckets.size());
        for (Map.Entry entry : buckets.entrySet()) {
            BlockWrapper blockWrapper = new BlockWrapper(((BlockWrapper)entry.getKey()).block, ((BlockWrapper)entry.getKey()).metadata);
            ItemWrapper itemWrapper = new ItemWrapper(((ItemWrapper)entry.getValue()).item, ((ItemWrapper)entry.getValue()).metadata);
            hashBiMap.put((Object)blockWrapper, (Object)itemWrapper);
        }
        buckets.clear();
        buckets = hashBiMap;
    }
}

