/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.crafting;

import cofh.core.util.crafting.RecipeUpgrade;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class RecipeUpgradeOverride
extends RecipeUpgrade {
    HashMap<String, NBTBase[]> overrides = new HashMap();

    public RecipeUpgradeOverride(ItemStack itemStack, Object[] objectArray) {
        super(itemStack, objectArray);
    }

    public RecipeUpgradeOverride(int n, ItemStack itemStack, Object[] objectArray) {
        super(n, itemStack, objectArray);
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventoryCrafting) {
        ItemStack itemStack = super.getCraftingResult(inventoryCrafting);
        if (itemStack.stackTagCompound != null) {
            for (Map.Entry<String, NBTBase[]> entry : this.overrides.entrySet()) {
                if (entry.getValue()[0] != null && !entry.getValue()[0].equals((Object)itemStack.stackTagCompound.getTag(entry.getKey()))) continue;
                itemStack.stackTagCompound.setTag(entry.getKey(), entry.getValue()[1].copy());
            }
        }
        return itemStack;
    }

    public RecipeUpgradeOverride addOverride(String string, NBTBase nBTBase, NBTBase nBTBase2) {
        this.overrides.put(string, new NBTBase[]{nBTBase, nBTBase2});
        return this;
    }

    public RecipeUpgradeOverride addByte(String string, byte by, byte by2) {
        return this.addOverride(string, (NBTBase)new NBTTagByte(by), (NBTBase)new NBTTagByte(by2));
    }

    public RecipeUpgradeOverride addShort(String string, short s, short s2) {
        return this.addOverride(string, (NBTBase)new NBTTagShort(s), (NBTBase)new NBTTagShort(s2));
    }

    public RecipeUpgradeOverride addInteger(String string, int n, int n2) {
        return this.addOverride(string, (NBTBase)new NBTTagInt(n), (NBTBase)new NBTTagInt(n2));
    }

    public RecipeUpgradeOverride addOverrideLong(String string, long l, long l2) {
        return this.addOverride(string, (NBTBase)new NBTTagLong(l), (NBTBase)new NBTTagLong(l2));
    }

    public RecipeUpgradeOverride addFloat(String string, float f, float f2) {
        return this.addOverride(string, (NBTBase)new NBTTagFloat(f), (NBTBase)new NBTTagFloat(f2));
    }

    public RecipeUpgradeOverride addDouble(String string, double d, double d2) {
        return this.addOverride(string, (NBTBase)new NBTTagDouble(d), (NBTBase)new NBTTagDouble(d2));
    }

    public RecipeUpgradeOverride addString(String string, String string2, String string3) {
        return this.addOverride(string, (NBTBase)new NBTTagString(string2), (NBTBase)new NBTTagString(string3));
    }

    public RecipeUpgradeOverride addByteArray(String string, byte[] byArray, byte[] byArray2) {
        return this.addOverride(string, (NBTBase)new NBTTagByteArray(byArray), (NBTBase)new NBTTagByteArray(byArray2));
    }

    public RecipeUpgradeOverride addIntArray(String string, int[] nArray, int[] nArray2) {
        return this.addOverride(string, (NBTBase)new NBTTagIntArray(nArray), (NBTBase)new NBTTagIntArray(nArray2));
    }

    public RecipeUpgradeOverride addBoolean(String string, boolean bl, boolean bl2) {
        return this.addByte(string, (byte)(bl ? 1 : 0), (byte)(bl2 ? 1 : 0));
    }
}

