/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.CoFHCore;
import cofh.core.CoFHProps;
import cofh.core.entity.EntityLightningBoltFake;
import cofh.lib.util.position.BlockPosition;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import org.apache.logging.log4j.core.helpers.Loader;

public class CoreUtils {
    public static int entityId = 0;

    public static int getEntityId() {
        return ++entityId;
    }

    public static String getModName(Item item) {
        String string = GameData.getItemRegistry().getNameForObject((Object)item);
        return string.substring(0, string.indexOf(58));
    }

    public static EntityPlayer getClientPlayer() {
        return CoFHCore.proxy.getClientPlayer();
    }

    public static boolean isPlayer(EntityPlayer entityPlayer) {
        return entityPlayer instanceof EntityPlayerMP;
    }

    public static boolean isFakePlayer(EntityPlayer entityPlayer) {
        return entityPlayer instanceof FakePlayer;
    }

    public static boolean isOp(EntityPlayer entityPlayer) {
        return CoFHCore.proxy.isOp(entityPlayer.getCommandSenderName());
    }

    public static boolean isOp(String string) {
        return CoFHCore.proxy.isOp(string);
    }

    public static boolean isClient() {
        return CoFHCore.proxy.isClient();
    }

    public static boolean isServer() {
        return CoFHCore.proxy.isServer();
    }

    public static boolean isBlockUnbreakable(World world, int n, int n2, int n3) {
        Block block = world.getBlock(n, n2, n3);
        return block instanceof BlockLiquid || block.getBlockHardness(world, n, n2, n3) < 0.0f;
    }

    public static boolean isRedstonePowered(World world, int n, int n2, int n3) {
        if (world.isBlockIndirectlyGettingPowered(n, n2, n3)) {
            return true;
        }
        for (BlockPosition blockPosition : new BlockPosition(n, n2, n3).getAdjacent(false)) {
            Block block = world.getBlock(blockPosition.x, blockPosition.y, blockPosition.z);
            if (!block.equals(Blocks.redstone_wire) || block.isProvidingStrongPower((IBlockAccess)world, blockPosition.x, blockPosition.y, blockPosition.z, 1) <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isRedstonePowered(TileEntity tileEntity) {
        return CoreUtils.isRedstonePowered(tileEntity.getWorldObj(), tileEntity.xCoord, tileEntity.yCoord, tileEntity.zCoord);
    }

    public static void dismantleLog(String string, Block block, int n, double d, double d2, double d3) {
        if (CoFHProps.enableDismantleLogging) {
            CoFHCore.log.info("Player " + string + " dismantled " + " (" + block + ":" + n + ") at (" + d + "," + d2 + "," + d3 + ")");
        }
    }

    public static void copyFileUsingStream(String string, String string2) throws IOException {
        CoreUtils.copyFileUsingStream(string, new File(string2));
    }

    public static void copyFileUsingStream(String string, File file) throws IOException {
        try (InputStream inputStream = Loader.getResource((String)string, null).openStream();
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
    }

    public static void copyFileUsingChannel(File file, File file2) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);
             FileChannel fileChannel = fileInputStream.getChannel();
             FileOutputStream fileOutputStream = new FileOutputStream(file2);){
            fileOutputStream.getChannel().transferFrom(fileChannel, 0L, fileChannel.size());
        }
    }

    public static final String getSoundName(String string, String string2) {
        string2 = string2.replaceAll("/", ".");
        return String.format("%s:%s", string, string2);
    }

    public static final float getSoundVolume(int n) {
        return CoFHCore.proxy.getSoundVolume(n);
    }

    public static boolean dropItemStackIntoWorld(ItemStack itemStack, World world, double d, double d2, double d3) {
        return CoreUtils.dropItemStackIntoWorld(itemStack, world, d, d2, d3, false);
    }

    public static boolean dropItemStackIntoWorldWithVelocity(ItemStack itemStack, World world, double d, double d2, double d3) {
        return CoreUtils.dropItemStackIntoWorld(itemStack, world, d, d2, d3, true);
    }

    public static boolean dropItemStackIntoWorld(ItemStack itemStack, World world, double d, double d2, double d3, boolean bl) {
        if (itemStack == null) {
            return false;
        }
        float f = 0.5f;
        float f2 = 0.0f;
        float f3 = 0.5f;
        if (bl) {
            f = world.rand.nextFloat() * 0.8f + 0.1f;
            f2 = world.rand.nextFloat() * 0.8f + 0.1f;
            f3 = world.rand.nextFloat() * 0.8f + 0.1f;
        }
        EntityItem entityItem = new EntityItem(world, d + (double)f, d2 + (double)f2, d3 + (double)f3, itemStack.copy());
        if (bl) {
            entityItem.motionX = (float)world.rand.nextGaussian() * 0.05f;
            entityItem.motionY = (float)world.rand.nextGaussian() * 0.05f + 0.2f;
            entityItem.motionZ = (float)world.rand.nextGaussian() * 0.05f;
        } else {
            entityItem.motionY = -0.05f;
            entityItem.motionX = 0.0;
            entityItem.motionZ = 0.0;
        }
        world.spawnEntityInWorld((Entity)entityItem);
        return true;
    }

    public static void doFakeExplosion(World world, double d, double d2, double d3, boolean bl) {
        world.spawnParticle("largeexplode", d, d2 + 1.0, d3, 0.0, 0.0, 0.0);
        if (bl) {
            world.playSound(d, d2, d3, "random.explode", 1.0f, 1.0f, true);
        }
    }

    public static void doFakeLightningBolt(World world, double d, double d2, double d3) {
        EntityLightningBoltFake entityLightningBoltFake = new EntityLightningBoltFake(world, d, d2, d3);
        world.addWeatherEffect((Entity)entityLightningBoltFake);
    }

    public static boolean teleportEntityTo(Entity entity, double d, double d2, double d3) {
        if (entity instanceof EntityLivingBase) {
            return CoreUtils.teleportEntityTo((EntityLivingBase)entity, d, d2, d3);
        }
        entity.setLocationAndAngles(d, d2, d3, entity.rotationYaw, entity.rotationPitch);
        entity.worldObj.playSoundAtEntity(entity, "mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    public static boolean teleportEntityTo(EntityLivingBase entityLivingBase, double d, double d2, double d3) {
        EnderTeleportEvent enderTeleportEvent = new EnderTeleportEvent(entityLivingBase, d, d2, d3, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)enderTeleportEvent)) {
            return false;
        }
        entityLivingBase.setPositionAndUpdate(enderTeleportEvent.targetX, enderTeleportEvent.targetY, enderTeleportEvent.targetZ);
        entityLivingBase.worldObj.playSoundAtEntity((Entity)entityLivingBase, "mob.endermen.portal", 1.0f, 1.0f);
        return true;
    }

    public static boolean teleportEntityTo(EntityLivingBase entityLivingBase, double d, double d2, double d3, boolean bl) {
        if (bl) {
            NBTTagCompound nBTTagCompound = entityLivingBase.getEntityData();
            long l = entityLivingBase.worldObj.getTotalWorldTime();
            if (nBTTagCompound.getLong("cofh:tD") > l) {
                return false;
            }
            nBTTagCompound.setLong("cofh:tD", l + 35L);
        }
        return CoreUtils.teleportEntityTo(entityLivingBase, d, d2, d3);
    }
}

