/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.particles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;

public abstract class ParticleBase {
    public static final float BASE_GRAVITY = 0.04f;
    protected static final ResourceLocation MC_PARTICLES = new ResourceLocation("textures/particle/particles.png");
    protected static final ResourceLocation MC_BLOCKS = TextureMap.locationBlocksTexture;
    protected static final ResourceLocation MC_ITEMS = TextureMap.locationItemsTexture;
    public static final Random rand = new Random();
    public static double interpPosX;
    public static double interpPosY;
    public static double interpPosZ;
    public static float rX;
    public static float rZ;
    public static float rYZ;
    public static float rXY;
    public static float rXZ;
    public final ResourceLocation location;
    protected final Vec3 prev;
    protected final Vec3 pos;
    protected double motX;
    protected double motY;
    protected double motZ;
    protected float r = 1.0f;
    protected float g = 1.0f;
    protected float b = 1.0f;
    protected float a = 1.0f;
    protected float size = 0.2f;
    protected int life;
    protected int maxLife;
    protected boolean onGround;
    protected float gravity = 0.04f;

    protected ParticleBase(double d, double d2, double d3, double d4, double d5, double d6, float f, int n, ResourceLocation resourceLocation) {
        this.pos = Vec3.createVectorHelper((double)d, (double)d2, (double)d3);
        this.prev = Vec3.createVectorHelper((double)d, (double)d2, (double)d3);
        this.motX = d4;
        this.motY = d5;
        this.motZ = d6;
        this.size = 0.1f * f;
        this.life = 0;
        this.maxLife = n;
        this.location = resourceLocation;
    }

    public final boolean advance() {
        this.copyVecValuesFrom(this.prev, this.pos);
        return this.checkLife() && this.handleMovement();
    }

    public boolean handleMovement() {
        this.motY -= (double)this.gravity;
        if (!this.moveEntity(this.motX, this.motY, this.motZ)) {
            return false;
        }
        this.applyFriction();
        return true;
    }

    public void applyFriction() {
        this.motX *= (double)0.98f;
        this.motY *= (double)0.98f;
        this.motZ *= (double)0.98f;
        if (this.onGround) {
            this.motX *= (double)0.7f;
            this.motZ *= (double)0.7f;
        }
    }

    public boolean checkLife() {
        return this.life++ < this.maxLife;
    }

    public void copyVecValuesFrom(Vec3 vec3, Vec3 vec32) {
        vec3.xCoord = vec32.xCoord;
        vec3.yCoord = vec32.yCoord;
        vec3.zCoord = vec32.zCoord;
    }

    protected boolean moveEntity(double d, double d2, double d3) {
        WorldClient worldClient = Minecraft.getMinecraft().theWorld;
        if (worldClient == null) {
            return false;
        }
        if (this.noClip()) {
            this.pos.addVector(d, d2, d3);
            return true;
        }
        if (d == 0.0 && d2 == 0.0 && d3 == 0.0) {
            return true;
        }
        this.pos.xCoord += d;
        this.pos.yCoord += d2;
        this.pos.zCoord += d3;
        MovingObjectPosition movingObjectPosition = worldClient.rayTraceBlocks(this.prev, this.pos);
        if (movingObjectPosition != null) {
            if (!this.collide(movingObjectPosition)) {
                return false;
            }
            this.motX = this.pos.xCoord - this.prev.xCoord;
            this.motY = this.pos.yCoord - this.prev.yCoord;
            this.motZ = this.pos.zCoord - this.prev.zCoord;
        }
        return true;
    }

    private boolean collide(MovingObjectPosition movingObjectPosition) {
        if (this.killOnCollide()) {
            return false;
        }
        this.copyVecValuesFrom(this.pos, movingObjectPosition.hitVec);
        this.onGround = this.motY < 0.0 && movingObjectPosition.sideHit == 1;
        return true;
    }

    protected boolean killOnCollide() {
        return true;
    }

    protected boolean noClip() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    protected int brightness(float f) {
        int n = MathHelper.floor_double((double)this.pos.xCoord);
        int n2 = MathHelper.floor_double((double)this.pos.zCoord);
        WorldClient worldClient = Minecraft.getMinecraft().theWorld;
        if (worldClient != null && worldClient.blockExists(n, 0, n2)) {
            int n3 = MathHelper.floor_double((double)this.pos.yCoord);
            return worldClient.getLightBrightnessForSkyBlocks(n, n3, n2, 0);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void render(Tessellator var1, double var2);

    @SideOnly(value=Side.CLIENT)
    public void renderParticle(Tessellator tessellator, double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.pos.xCoord + (this.pos.xCoord - this.prev.xCoord) * d - interpPosX;
        double d8 = this.pos.yCoord + (this.pos.yCoord - this.prev.yCoord) * d - interpPosY;
        double d9 = this.pos.zCoord + (this.pos.zCoord - this.prev.zCoord) * d - interpPosZ;
        tessellator.setColorRGBA_F(this.r, this.g, this.b, this.a);
        tessellator.addVertexWithUV(d7 - (double)rX * d2 - (double)rYZ * d2, d8 - (double)rXZ * d2, d9 - (double)rZ * d2 - (double)rXY * d2, d4, d6);
        tessellator.addVertexWithUV(d7 - (double)rX * d2 + (double)rYZ * d2, d8 + (double)rXZ * d2, d9 - (double)rZ * d2 + (double)rXY * d2, d4, d5);
        tessellator.addVertexWithUV(d7 + (double)rX * d2 + (double)rYZ * d2, d8 + (double)rXZ * d2, d9 + (double)rZ * d2 + (double)rXY * d2, d3, d5);
        tessellator.addVertexWithUV(d7 + (double)rX * d2 - (double)rYZ * d2, d8 - (double)rXZ * d2, d9 + (double)rZ * d2 - (double)rXY * d2, d3, d6);
    }

    public <T extends ParticleBase> T setColor(float f, float f2, float f3) {
        this.r = f;
        this.g = f2;
        this.b = f3;
        return (T)this;
    }

    public <T extends ParticleBase> T setColor(int n) {
        this.r = (float)((n & 0xFF0000) >> 16) / 255.0f;
        this.g = (float)((n & 0xFF00) >> 8) / 255.0f;
        this.b = (float)(n & 0xFF) / 255.0f;
        return (T)this;
    }

    public <T extends ParticleBase> T setAlpha(float f) {
        this.a = f;
        return (T)this;
    }

    public <T extends ParticleBase> T setSize(float f) {
        this.size = 0.1f * f;
        return (T)this;
    }
}

