/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item.tool;

import cofh.core.item.tool.ItemToolAdv;
import cofh.core.util.CoreUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;

public class ItemSickleAdv
extends ItemToolAdv {
    public int radius = 3;

    public ItemSickleAdv(Item.ToolMaterial toolMaterial) {
        super(3.0f, toolMaterial);
        this.addToolClass("sickle");
        this.effectiveMaterials.add((Object)Material.leaves);
        this.effectiveMaterials.add((Object)Material.plants);
        this.effectiveMaterials.add((Object)Material.vine);
        this.effectiveMaterials.add((Object)Material.web);
        this.effectiveBlocks.add((Object)Blocks.web);
        this.effectiveBlocks.add((Object)Blocks.vine);
    }

    public ItemSickleAdv setRadius(int n) {
        this.radius = n;
        return this;
    }

    @Override
    protected boolean harvestBlock(World world, int n, int n2, int n3, EntityPlayer entityPlayer) {
        if (world.isAirBlock(n, n2, n3)) {
            return false;
        }
        EntityPlayerMP entityPlayerMP = null;
        if (entityPlayer instanceof EntityPlayerMP) {
            entityPlayerMP = (EntityPlayerMP)entityPlayer;
        }
        Block block = world.getBlock(n, n2, n3);
        int n4 = world.getBlockMetadata(n, n2, n3);
        if (!this.getToolClasses(entityPlayer.getCurrentEquippedItem()).contains(block.getHarvestTool(n4)) && !this.canHarvestBlock(block, entityPlayer.getCurrentEquippedItem())) {
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)entityPlayer, (int)n4)) {
            return false;
        }
        BlockEvent.BreakEvent breakEvent = null;
        if (entityPlayerMP != null && (breakEvent = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)entityPlayerMP.theItemInWorldManager.getGameType(), (EntityPlayerMP)entityPlayerMP, (int)n, (int)n2, (int)n3)).isCanceled()) {
            return false;
        }
        if (entityPlayer.capabilities.isCreativeMode) {
            if (!world.isRemote) {
                block.onBlockHarvested(world, n, n2, n3, n4, entityPlayer);
            }
            if (block.removedByPlayer(world, entityPlayer, n, n2, n3, false)) {
                block.onBlockDestroyedByPlayer(world, n, n2, n3, n4);
            }
            if (!world.isRemote) {
                entityPlayerMP.playerNetServerHandler.sendPacket((Packet)new S23PacketBlockChange(n, n2, n3, world));
            } else {
                Minecraft.getMinecraft().getNetHandler().addToSendQueue((Packet)new C07PacketPlayerDigging(2, n, n2, n3, Minecraft.getMinecraft().objectMouseOver.sideHit));
            }
            return true;
        }
        if (!world.isRemote) {
            block.onBlockHarvested(world, n, n2, n3, n4, entityPlayer);
            if (block.removedByPlayer(world, entityPlayer, n, n2, n3, true)) {
                block.onBlockDestroyedByPlayer(world, n, n2, n3, n4);
                block.harvestBlock(world, entityPlayer, n, n2, n3, n4);
                if (block.equals(Blocks.vine)) {
                    CoreUtils.dropItemStackIntoWorldWithVelocity(new ItemStack(Blocks.vine), world, n, n2, n3);
                }
                if (breakEvent != null) {
                    block.dropXpOnBlockBreak(world, n, n2, n3, breakEvent.getExpToDrop());
                }
            }
            entityPlayerMP.playerNetServerHandler.sendPacket((Packet)new S23PacketBlockChange(n, n2, n3, world));
        } else {
            if (block.removedByPlayer(world, entityPlayer, n, n2, n3, true)) {
                block.onBlockDestroyedByPlayer(world, n, n2, n3, n4);
            }
            Minecraft.getMinecraft().getNetHandler().addToSendQueue((Packet)new C07PacketPlayerDigging(2, n, n2, n3, Minecraft.getMinecraft().objectMouseOver.sideHit));
        }
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemStack, int n, int n2, int n3, EntityPlayer entityPlayer) {
        World world = entityPlayer.worldObj;
        Block block = world.getBlock(n, n2, n3);
        if (!this.canHarvestBlock(block, itemStack)) {
            if (!entityPlayer.capabilities.isCreativeMode) {
                itemStack.damageItem(1, (EntityLivingBase)entityPlayer);
            }
            return false;
        }
        boolean bl = false;
        world.playAuxSFXAtEntity(entityPlayer, 2001, n, n2, n3, Block.getIdFromBlock((Block)block) | world.getBlockMetadata(n, n2, n3) << 12);
        for (int i = n - this.radius; i <= n + this.radius; ++i) {
            for (int j = n3 - this.radius; j <= n3 + this.radius; ++j) {
                bl |= this.harvestBlock(world, i, n2, j, entityPlayer);
            }
        }
        if (bl && !entityPlayer.capabilities.isCreativeMode) {
            itemStack.damageItem(1, (EntityLivingBase)entityPlayer);
        }
        return true;
    }
}

