/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item.tool;

import cofh.core.entity.EntityCoFHFishHook;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.ItemHelper;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemFishingRodAdv
extends ItemFishingRod {
    protected IIcon[] normalIcons = new IIcon[2];
    public String repairIngot = "";
    protected Item.ToolMaterial toolMaterial;
    protected boolean showInCreative = true;
    protected int luckModifier = 0;
    protected int speedModifier = 0;

    public ItemFishingRodAdv(Item.ToolMaterial toolMaterial) {
        this.toolMaterial = toolMaterial;
        this.setMaxDamage(toolMaterial.getMaxUses());
    }

    public ItemFishingRodAdv setRepairIngot(String string) {
        this.repairIngot = string;
        return this;
    }

    public ItemFishingRodAdv setShowInCreative(boolean bl) {
        this.showInCreative = bl;
        return this;
    }

    public ItemFishingRodAdv setLuckModifier(int n) {
        this.luckModifier = n;
        return this;
    }

    public ItemFishingRodAdv setSpeedModifier(int n) {
        this.speedModifier = n;
        return this;
    }

    public void getSubItems(Item item, CreativeTabs creativeTabs, List list) {
        if (this.showInCreative) {
            list.add(new ItemStack(item, 1, 0));
        }
    }

    public int getItemEnchantability() {
        return this.toolMaterial.getEnchantability();
    }

    public boolean getIsRepairable(ItemStack itemStack, ItemStack itemStack2) {
        return ItemHelper.isOreNameEqual(itemStack2, this.repairIngot);
    }

    public boolean isFull3D() {
        return true;
    }

    public boolean isItemTool(ItemStack itemStack) {
        return true;
    }

    public ItemStack onItemRightClick(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (entityPlayer.fishEntity != null) {
            int n = entityPlayer.fishEntity.func_146034_e();
            itemStack.damageItem(n, (EntityLivingBase)entityPlayer);
            entityPlayer.swingItem();
        } else {
            world.playSoundAtEntity((Entity)entityPlayer, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
            if (!world.isRemote) {
                world.spawnEntityInWorld((Entity)new EntityCoFHFishHook(world, entityPlayer, this.luckModifier, this.speedModifier));
            }
            entityPlayer.swingItem();
        }
        return itemStack;
    }

    public IIcon getIconIndex(ItemStack itemStack) {
        return this.getIcon(itemStack, 0);
    }

    public IIcon getIcon(ItemStack itemStack, int n) {
        EntityPlayer entityPlayer = CoreUtils.getClientPlayer();
        if (entityPlayer.inventory.getCurrentItem() == itemStack && entityPlayer.fishEntity != null) {
            return this.normalIcons[1];
        }
        return this.normalIcons[0];
    }

    public void registerIcons(IIconRegister iIconRegister) {
        this.normalIcons[0] = iIconRegister.registerIcon(this.getIconString() + "_Uncast");
        this.normalIcons[1] = iIconRegister.registerIcon(this.getIconString() + "_Cast");
    }
}

