/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.render.CoFHFontRenderer;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemBlockBase
extends ItemBlock {
    public ItemBlockBase(Block block) {
        super(block);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
    }

    public String getItemStackDisplayName(ItemStack itemStack) {
        return StringHelper.localize(this.getUnlocalizedName(itemStack));
    }

    public int getMetadata(int n) {
        return n;
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return SecurityHelper.isSecure(itemStack);
    }

    public boolean isItemTool(ItemStack itemStack) {
        return false;
    }

    public Entity createEntity(World world, Entity entity, ItemStack itemStack) {
        if (SecurityHelper.isSecure(itemStack)) {
            entity.invulnerable = true;
            entity.isImmuneToFire = true;
            ((EntityItem)entity).lifespan = Integer.MAX_VALUE;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack itemStack) {
        return CoFHFontRenderer.loadFontRendererStack(itemStack);
    }
}

