/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.render.CoFHFontRenderer;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemBase
extends Item {
    public TMap<Integer, ItemEntry> itemMap = new THashMap();
    public ArrayList<Integer> itemList = new ArrayList();
    public boolean hasTextures = true;
    public String modName = "cofh";

    public ItemBase() {
        this.setHasSubtypes(true);
    }

    public ItemBase(String string) {
        this.modName = string;
        this.setHasSubtypes(true);
    }

    public ItemBase setHasTextures(boolean bl) {
        this.hasTextures = bl;
        return this;
    }

    public ItemStack addItem(int n, ItemEntry itemEntry, boolean bl) {
        if (this.itemMap.containsKey((Object)n)) {
            return null;
        }
        this.itemMap.put((Object)n, (Object)itemEntry);
        this.itemList.add(n);
        ItemStack itemStack = new ItemStack((Item)this, 1, n);
        if (bl) {
            GameRegistry.registerCustomItemStack((String)itemEntry.name, (ItemStack)itemStack);
        }
        return itemStack;
    }

    public ItemStack addItem(int n, ItemEntry itemEntry) {
        return this.addItem(n, itemEntry, true);
    }

    public ItemStack addItem(int n, String string, int n2, boolean bl) {
        return this.addItem(n, new ItemEntry(string, n2), bl);
    }

    public ItemStack addItem(int n, String string, int n2) {
        return this.addItem(n, string, n2, true);
    }

    public ItemStack addItem(int n, String string) {
        return this.addItem(n, string, 0);
    }

    public ItemStack addOreDictItem(int n, String string, int n2) {
        ItemStack itemStack = this.addItem(n, string, n2);
        OreDictionary.registerOre((String)string, (ItemStack)itemStack);
        return itemStack;
    }

    public ItemStack addOreDictItem(int n, String string) {
        ItemStack itemStack = this.addItem(n, string);
        OreDictionary.registerOre((String)string, (ItemStack)itemStack);
        return itemStack;
    }

    public String getRawName(ItemStack itemStack) {
        int n = ItemHelper.getItemDamage(itemStack);
        if (!this.itemMap.containsKey((Object)n)) {
            return "invalid";
        }
        return ((ItemEntry)this.itemMap.get((Object)Integer.valueOf((int)n))).name;
    }

    public IIcon getIconFromDamage(int n) {
        if (!this.itemMap.containsKey((Object)n)) {
            return null;
        }
        return ((ItemEntry)this.itemMap.get((Object)Integer.valueOf((int)n))).icon;
    }

    public EnumRarity getRarity(ItemStack itemStack) {
        int n = itemStack.getItemDamage();
        if (!this.itemMap.containsKey((Object)n)) {
            return EnumRarity.common;
        }
        return EnumRarity.values()[((ItemEntry)this.itemMap.get((Object)Integer.valueOf((int)itemStack.getItemDamage()))).rarity];
    }

    public void getSubItems(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < this.itemList.size(); ++i) {
            list.add(new ItemStack(item, 1, this.itemList.get(i).intValue()));
        }
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        int n = ItemHelper.getItemDamage(itemStack);
        if (!this.itemMap.containsKey((Object)n)) {
            return "item.invalid";
        }
        ItemEntry itemEntry = (ItemEntry)this.itemMap.get((Object)n);
        if (itemEntry.altName) {
            return this.getUnlocalizedName() + '.' + itemEntry.name + "Alt";
        }
        return this.getUnlocalizedName() + '.' + itemEntry.name;
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return SecurityHelper.isSecure(itemStack);
    }

    public Entity createEntity(World world, Entity entity, ItemStack itemStack) {
        if (SecurityHelper.isSecure(itemStack)) {
            entity.invulnerable = true;
            entity.isImmuneToFire = true;
            ((EntityItem)entity).lifespan = Integer.MAX_VALUE;
        }
        return null;
    }

    public Item setUnlocalizedName(String string) {
        GameRegistry.registerItem((Item)this, (String)string);
        string = this.modName + "." + string;
        return super.setUnlocalizedName(string);
    }

    public Item setUnlocalizedName(String string, String string2) {
        GameRegistry.registerItem((Item)this, (String)string2);
        string = this.modName + "." + string;
        return super.setUnlocalizedName(string);
    }

    public void registerIcons(IIconRegister iIconRegister) {
        if (!this.hasTextures) {
            return;
        }
        for (int i = 0; i < this.itemList.size(); ++i) {
            ItemEntry itemEntry = (ItemEntry)this.itemMap.get((Object)this.itemList.get(i));
            itemEntry.icon = this.registerIcon(iIconRegister, itemEntry);
        }
    }

    protected IIcon registerIcon(IIconRegister iIconRegister, ItemEntry itemEntry) {
        return iIconRegister.registerIcon(this.modName + ":" + this.getUnlocalizedName().replace("item." + this.modName + ".", "") + "/" + StringHelper.titleCase(itemEntry.name));
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack itemStack) {
        return CoFHFontRenderer.loadFontRendererStack(itemStack);
    }

    public class ItemEntry {
        public String name;
        public IIcon icon;
        public int rarity = 0;
        public int maxDamage = 0;
        public boolean altName = false;

        public ItemEntry(String string, int n, int n2) {
            this.name = string;
            this.rarity = n;
            this.maxDamage = n2;
        }

        public ItemEntry(String string, int n) {
            this.name = string;
            this.rarity = n;
        }

        public ItemEntry(String string) {
            this.name = string;
        }

        public ItemEntry useAltName(boolean bl) {
            this.altName = bl;
            return this;
        }
    }
}

