/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.slot;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class SlotPlayerAugment
extends Slot {
    public static final String AUGMENT_KEY = "cofhAugment";
    EntityPlayer thePlayer;

    public SlotPlayerAugment(EntityPlayer entityPlayer, int n, int n2, int n3) {
        super(null, n, n2, n3);
        this.thePlayer = entityPlayer;
    }

    public boolean isItemValid(ItemStack itemStack) {
        return itemStack != null;
    }

    public ItemStack getStack() {
        if (this.thePlayer.getEntityData().hasKey(AUGMENT_KEY + this.getSlotIndex())) {
            return ItemStack.loadItemStackFromNBT((NBTTagCompound)this.thePlayer.getEntityData().getCompoundTag(AUGMENT_KEY + this.getSlotIndex()));
        }
        return null;
    }

    public void putStack(ItemStack itemStack) {
        if (itemStack == null || itemStack.stackSize <= 0) {
            this.thePlayer.getEntityData().removeTag(AUGMENT_KEY + this.getSlotIndex());
        } else {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            itemStack.writeToNBT(nBTTagCompound);
            this.thePlayer.getEntityData().setTag(AUGMENT_KEY + this.getSlotIndex(), (NBTBase)nBTTagCompound);
        }
        this.onSlotChanged();
    }

    public void onSlotChanged() {
    }

    public int getSlotStackLimit() {
        return 1;
    }

    public ItemStack decrStackSize(int n) {
        ItemStack itemStack = this.getStack();
        if (itemStack != null) {
            if (itemStack.stackSize <= n) {
                this.putStack(null);
                return itemStack;
            }
            ItemStack itemStack2 = itemStack.splitStack(n);
            if (itemStack.stackSize == 0) {
                this.putStack(null);
            } else {
                this.putStack(itemStack);
            }
            return itemStack2;
        }
        return null;
    }
}

