/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element;

import cofh.CoFHCore;
import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.IReconfigurableSides;
import cofh.api.tileentity.ISidedTexture;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.TabBase;
import cofh.lib.render.RenderHelper;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.opengl.GL11;

public class TabConfiguration
extends TabBase {
    public static boolean enable;
    public static int defaultSide;
    public static int defaultHeaderColor;
    public static int defaultSubHeaderColor;
    public static int defaultTextColor;
    public static int defaultBackgroundColor;
    IReconfigurableFacing myTile;
    IReconfigurableSides myTileSides;
    ISidedTexture myTileTexture;

    public static void initialize() {
        String string = "Tab.Configuration";
        defaultSide = MathHelper.clamp(CoFHCore.configClient.get(string, "Side", defaultSide), 0, 1);
        defaultHeaderColor = MathHelper.clamp(CoFHCore.configClient.get(string, "ColorHeader", defaultHeaderColor), 0, 0xFFFFFF);
        defaultSubHeaderColor = MathHelper.clamp(CoFHCore.configClient.get(string, "ColorSubHeader", defaultSubHeaderColor), 0, 0xFFFFFF);
        defaultTextColor = MathHelper.clamp(CoFHCore.configClient.get(string, "ColorText", defaultTextColor), 0, 0xFFFFFF);
        defaultBackgroundColor = MathHelper.clamp(CoFHCore.configClient.get(string, "ColorBackground", defaultBackgroundColor), 0, 0xFFFFFF);
        CoFHCore.configClient.save();
    }

    public TabConfiguration(GuiBase guiBase, IReconfigurableFacing iReconfigurableFacing) {
        this(guiBase, defaultSide, iReconfigurableFacing);
    }

    public TabConfiguration(GuiBase guiBase, int n, IReconfigurableFacing iReconfigurableFacing) {
        super(guiBase, n);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 100;
        this.myTile = iReconfigurableFacing;
        this.myTileSides = (IReconfigurableSides)((Object)iReconfigurableFacing);
        this.myTileTexture = (ISidedTexture)((Object)iReconfigurableFacing);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize("info.cofh.configuration"));
            return;
        }
    }

    @Override
    public boolean onMousePressed(int n, int n2, int n3) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if (this.side == 0) {
            n += this.currentWidth;
        }
        if ((n -= this.currentShiftX) < 16 || n >= 80 || (n2 -= this.currentShiftY) < 20 || n2 >= 84) {
            return false;
        }
        if (40 <= n && n < 56 && 24 <= n2 && n2 < 40) {
            this.handleSideChange(BlockHelper.SIDE_ABOVE[this.myTile.getFacing()], n3);
        } else if (20 <= n && n < 36 && 44 <= n2 && n2 < 60) {
            this.handleSideChange(BlockHelper.SIDE_LEFT[this.myTile.getFacing()], n3);
        } else if (40 <= n && n < 56 && 44 <= n2 && n2 < 60) {
            this.handleSideChange(this.myTile.getFacing(), n3);
        } else if (60 <= n && n < 76 && 44 <= n2 && n2 < 60) {
            this.handleSideChange(BlockHelper.SIDE_RIGHT[this.myTile.getFacing()], n3);
        } else if (40 <= n && n < 56 && 64 <= n2 && n2 < 80) {
            this.handleSideChange(BlockHelper.SIDE_BELOW[this.myTile.getFacing()], n3);
        } else if (60 <= n && n < 76 && 64 <= n2 && n2 < 80) {
            this.handleSideChange(BlockHelper.SIDE_OPPOSITE[this.myTile.getFacing()], n3);
        }
        return true;
    }

    @Override
    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float f = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float f2 = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float f3 = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GL11.glColor4f((float)f, (float)f2, (float)f3, (float)1.0f);
        this.gui.drawTexturedModalRect(this.posX() + 16, this.posY + 20, 16, 20, 64, 64);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void drawForeground() {
        this.drawTabIcon("IconConfig");
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().drawStringWithShadow(StringHelper.localize("info.cofh.configuration"), this.posXOffset() + 18, this.posY + 6, this.headerColor);
        RenderHelper.setBlockTextureSheet();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        for (int i = 0; i < 2; ++i) {
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_ABOVE[this.myTile.getFacing()], i), this.posX() + 40, this.posY + 24, 0);
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_LEFT[this.myTile.getFacing()], i), this.posX() + 20, this.posY + 44, 0);
            this.gui.drawIcon(this.myTileTexture.getTexture(this.myTile.getFacing(), i), this.posX() + 40, this.posY + 44, 0);
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_RIGHT[this.myTile.getFacing()], i), this.posX() + 60, this.posY + 44, 0);
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_BELOW[this.myTile.getFacing()], i), this.posX() + 40, this.posY + 64, 0);
            this.gui.drawIcon(this.myTileTexture.getTexture(BlockHelper.SIDE_OPPOSITE[this.myTile.getFacing()], i), this.posX() + 60, this.posY + 64, 0);
        }
        GL11.glDisable((int)3042);
        RenderHelper.setDefaultFontTextureSheet();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    void handleSideChange(int n, int n2) {
        if (GuiScreen.isShiftKeyDown()) {
            if (n == this.myTile.getFacing()) {
                if (this.myTileSides.resetSides()) {
                    GuiBase.playSound("random.click", 1.0f, 0.2f);
                }
            } else if (this.myTileSides.setSide(n, 0)) {
                GuiBase.playSound("random.click", 1.0f, 0.4f);
            }
            return;
        }
        if (n2 == 0) {
            if (this.myTileSides.incrSide(n)) {
                GuiBase.playSound("random.click", 1.0f, 0.8f);
            }
        } else if (n2 == 1 && this.myTileSides.decrSide(n)) {
            GuiBase.playSound("random.click", 1.0f, 0.6f);
        }
    }

    static {
        defaultSide = 1;
        defaultHeaderColor = 14797103;
        defaultSubHeaderColor = 11186104;
        defaultTextColor = 0;
        defaultBackgroundColor = 0x226688;
    }
}

