/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.client;

import cofh.core.RegistrySocial;
import cofh.core.gui.GuiBaseAdv;
import cofh.core.gui.GuiTextList;
import cofh.core.gui.container.ContainerFriendsList;
import cofh.core.gui.element.TabInfo;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketSocial;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementButton;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiFriendsList
extends GuiBaseAdv {
    static final String TEXTURE_PATH = "cofh:textures/gui/FriendsList.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("cofh:textures/gui/FriendsList.png");
    static final int TB_HEIGHT = 12;
    GuiTextField tbName;
    GuiTextList taOnlineList;
    public GuiTextList taFriendsList;
    ElementButton flUp;
    ElementButton flDown;
    ElementButton olUp;
    ElementButton olDown;
    ElementButton addName;
    ElementButton removeName;
    String tempName = "";
    int tbNameX = 0;
    int tbNameY = 0;
    int taX = 0;
    int taY = 0;
    int taflX = 0;
    int taflY = 0;

    public GuiFriendsList(InventoryPlayer inventoryPlayer) {
        super(new ContainerFriendsList(inventoryPlayer), TEXTURE);
        this.name = "info.cofh.friendsList";
        this.drawInventory = false;
        this.ySize = 188;
        this.generateInfo("tab.cofh.friend", 2);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.addTab(new TabInfo((GuiBase)this, this.myInfo));
        this.tbNameX = this.guiLeft + 8 + 4;
        this.tbNameY = this.guiTop + 15 + 2;
        this.taX = this.guiLeft + 8;
        this.taY = this.guiTop + 32;
        this.taflX = this.guiLeft + 8;
        this.taflY = this.guiTop + 80;
        String string = "";
        if (this.tbName != null) {
            string = this.tbName.getText();
        }
        this.tbName = new GuiTextField(this.fontRendererObj, this.tbNameX, this.tbNameY, 128, 12);
        this.tbName.setMaxStringLength(20);
        this.tbName.setText(string);
        this.tbName.setEnableBackgroundDrawing(false);
        this.taFriendsList = new GuiTextList(this.fontRendererObj, this.taflX, this.taflY, 128, 10);
        this.taFriendsList.textLines = RegistrySocial.clientPlayerFriends;
        this.taFriendsList.drawBackground = false;
        this.taFriendsList.drawBorder = false;
        this.taOnlineList = new GuiTextList(this.fontRendererObj, this.taX, this.taY, 128, 4);
        this.taOnlineList.textLines = this.getOnlineNames();
        this.taOnlineList.drawBackground = false;
        this.taOnlineList.drawBorder = false;
        this.addName = new ElementButton(this, 139, 13, "SetName", 208, 128, 208, 144, 208, 160, 16, 16, TEXTURE_PATH);
        this.removeName = new ElementButton(this, 155, 13, "RemoveName", 224, 128, 224, 144, 224, 160, 16, 16, TEXTURE_PATH);
        this.olUp = new ElementButton(this, 147, 33, "OnlineUp", 208, 64, 208, 80, 208, 96, 16, 16, TEXTURE_PATH);
        this.olDown = new ElementButton(this, 147, 58, "OnlineDown", 224, 64, 224, 80, 224, 96, 16, 16, TEXTURE_PATH);
        this.flUp = new ElementButton(this, 147, 87, "FriendsUp", 208, 64, 208, 80, 208, 96, 16, 16, TEXTURE_PATH);
        this.flDown = new ElementButton(this, 147, 159, "FriendsDown", 224, 64, 224, 80, 224, 96, 16, 16, TEXTURE_PATH);
        this.addElement(this.addName);
        this.addElement(this.removeName);
        this.addElement(this.olUp);
        this.addElement(this.olDown);
        this.addElement(this.flUp);
        this.addElement(this.flDown);
        this.updateButtons();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    @Override
    public void handleElementButtonClick(String string, int n) {
        if (string.equals("SetName")) {
            PacketHandler.sendToServer(new PacketSocial().addByte(PacketSocial.PacketTypes.ADD_FRIEND.ordinal()).addString(this.tbName.getText()));
        } else if (string.equals("RemoveName")) {
            PacketHandler.sendToServer(new PacketSocial().addByte(PacketSocial.PacketTypes.REMOVE_FRIEND.ordinal()).addString(this.tbName.getText()));
        } else if (string.equals("OnlineUp")) {
            this.taOnlineList.scrollDown();
        } else if (string.equals("OnlineDown")) {
            this.taOnlineList.scrollUp();
        } else if (string.equals("FriendsUp")) {
            this.taFriendsList.scrollDown();
        } else if (string.equals("FriendsDown")) {
            this.taFriendsList.scrollUp();
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int n, int n2) {
        super.drawGuiContainerBackgroundLayer(f, n, n2);
        this.mc.renderEngine.bindTexture(TEXTURE);
        this.tbName.drawTextBox();
        this.taOnlineList.drawText();
        this.taFriendsList.drawText();
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int n, int n2) {
        super.drawGuiContainerForegroundLayer(n, n2);
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.onGuiClosed();
    }

    public void updateScreen() {
        this.tbName.updateCursorCounter();
    }

    @Override
    protected void keyTyped(char c, int n) {
        this.tbName.textboxKeyTyped(c, n);
        if (n == 1) {
            this.mc.thePlayer.closeScreen();
            return;
        }
        if (this.tbName.isFocused() && n == 28) {
            GuiFriendsList.playSound("random.click", 1.0f, 0.7f);
        }
        this.updateButtons();
    }

    @Override
    protected void mouseClicked(int n, int n2, int n3) {
        int n4 = this.taFriendsList.xPos - this.guiLeft;
        int n5 = this.taFriendsList.yPos - this.guiTop;
        int n6 = this.taOnlineList.xPos - this.guiLeft;
        int n7 = this.taOnlineList.yPos - this.guiTop;
        if (n6 <= this.mouseX && this.mouseX < n6 + this.taOnlineList.width && this.mouseY >= n7 && this.mouseY < n7 + this.taOnlineList.height) {
            if (!this.taOnlineList.mouseClicked(this.mouseX, this.mouseY, n3, n7).equalsIgnoreCase(this.tbName.getText())) {
                this.tbName.setText(this.taOnlineList.mouseClicked(this.mouseX, this.mouseY, n3, n7));
            }
        } else if (n4 <= this.mouseX && this.mouseX < n4 + this.taFriendsList.width && this.mouseY >= n5 && this.mouseY < n5 + this.taFriendsList.height) {
            if (!this.taFriendsList.mouseClicked(this.mouseX, this.mouseY, n3, n5).equalsIgnoreCase(this.tbName.getText())) {
                this.tbName.setText(this.taFriendsList.mouseClicked(this.mouseX, this.mouseY, n3, n5));
            }
        } else if (this.tbNameX - this.guiLeft <= this.mouseX && this.mouseX < this.tbNameX - this.guiLeft + this.tbName.getWidth() && this.mouseY >= this.tbNameY - this.guiTop && this.mouseY < this.tbNameY - this.guiTop + 12) {
            this.tbName.setFocused(true);
        } else {
            super.mouseClicked(n, n2, n3);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        if (this.canScrollUpFriend()) {
            this.flUp.setActive();
        } else {
            this.flUp.setDisabled();
        }
        if (this.canScrollDownFriend()) {
            this.flDown.setActive();
        } else {
            this.flDown.setDisabled();
        }
        if (this.canScrollUpOnline()) {
            this.olUp.setActive();
        } else {
            this.olUp.setDisabled();
        }
        if (this.canScrollDownOnline()) {
            this.olDown.setActive();
        } else {
            this.olDown.setDisabled();
        }
        if (RegistrySocial.clientPlayerFriends.contains(this.tbName.getText().toLowerCase(Locale.US))) {
            this.addName.setDisabled();
            this.removeName.setActive();
        } else {
            this.addName.setActive();
            this.removeName.setDisabled();
        }
    }

    @Override
    public void handleMouseInput() {
        super.handleMouseInput();
        int n = this.taFriendsList.xPos - this.guiLeft;
        int n2 = this.taFriendsList.yPos - this.guiTop;
        int n3 = this.taOnlineList.xPos - this.guiLeft;
        int n4 = this.taOnlineList.yPos - this.guiTop;
        if (n <= this.mouseX && this.mouseX < n + this.taFriendsList.width && this.mouseY >= n2 && this.mouseY < n2 + this.taFriendsList.height) {
            int n5 = Mouse.getEventDWheel();
            if (n5 < 0) {
                this.taFriendsList.scrollUp();
            }
            if (n5 > 0) {
                this.taFriendsList.scrollDown();
            }
        } else if (n3 <= this.mouseX && this.mouseX < n3 + this.taOnlineList.width && this.mouseY >= n4 && this.mouseY < n4 + this.taOnlineList.height) {
            int n6 = Mouse.getEventDWheel();
            if (n6 < 0) {
                this.taOnlineList.scrollUp();
            }
            if (n6 > 0) {
                this.taOnlineList.scrollDown();
            }
        }
        this.updateButtons();
    }

    private boolean canScrollUpOnline() {
        return this.taOnlineList.startLine != 0;
    }

    private boolean canScrollDownOnline() {
        return this.taOnlineList.textLines.size() > this.taOnlineList.displayLines && this.taOnlineList.startLine < this.taOnlineList.textLines.size() - this.taOnlineList.displayLines;
    }

    private boolean canScrollUpFriend() {
        return this.taFriendsList.startLine != 0;
    }

    private boolean canScrollDownFriend() {
        return this.taFriendsList.textLines.size() > this.taFriendsList.displayLines && this.taFriendsList.startLine < this.taFriendsList.textLines.size() - this.taFriendsList.displayLines;
    }

    public List<String> getOnlineNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Object e : Minecraft.getMinecraft().thePlayer.sendQueue.playerInfoList) {
            linkedList.add(((GuiPlayerInfo)e).name);
        }
        return linkedList;
    }
}

