/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.entity;

import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;

public class EntitySelectorInRangeByType
implements IEntitySelector {
    private final double origX;
    private final double origY;
    private final double origZ;
    private final double distance;
    private final Class<?>[] types;

    public EntitySelectorInRangeByType(Entity entity, double d, Class<?> ... classArray) {
        this(entity.posX, entity.posY, entity.posZ, d, classArray);
    }

    public EntitySelectorInRangeByType(double d, double d2, double d3, double d4, Class<?> ... classArray) {
        this.origX = d;
        this.origY = d2;
        this.origZ = d3;
        this.distance = d4;
        this.types = classArray;
    }

    public boolean isEntityApplicable(Entity entity) {
        if (entity.getDistanceSq(this.origX, this.origY, this.origZ) > this.distance * this.distance) {
            return false;
        }
        if (this.types == null) {
            return true;
        }
        for (Class<?> clazz : this.types) {
            if (!clazz.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return false;
    }
}

