/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.enchantment;

import cofh.CoFHCore;
import cofh.core.enchantment.EnchantmentHolding;
import cofh.core.enchantment.EnchantmentMultishot;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CoFHEnchantment {
    public static Enchantment holding;
    public static Enchantment multishot;

    private CoFHEnchantment() {
    }

    public static void postInit() {
        int n;
        int n2;
        for (n2 = n = CoFHCore.configCore.get("Enchantment", "Holding", 100); n2 < 256; ++n2) {
            try {
                holding = new EnchantmentHolding(n2);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        CoFHCore.configCore.set("Enchantment", "Holding", CoFHEnchantment.holding.effectId);
        for (n2 = n = CoFHCore.configCore.get("Enchantment", "Multishot", 101); n2 < 256; ++n2) {
            try {
                multishot = new EnchantmentMultishot(n2);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        CoFHCore.configCore.set("Enchantment", "Multishot", CoFHEnchantment.multishot.effectId);
    }

    public static NBTTagList getEnchantmentTagList(NBTTagCompound nBTTagCompound) {
        return nBTTagCompound == null ? null : nBTTagCompound.getTagList("ench", 10);
    }

    public static void addEnchantment(NBTTagCompound nBTTagCompound, int n, int n2) {
        NBTTagList nBTTagList;
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        if ((nBTTagList = CoFHEnchantment.getEnchantmentTagList(nBTTagCompound)) == null) {
            nBTTagList = new NBTTagList();
        }
        boolean bl = false;
        for (int i = 0; i < nBTTagList.tagCount() && !bl; ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.getCompoundTagAt(i);
            if (nBTTagCompound2.getShort("id") != n) continue;
            nBTTagCompound2.setShort("id", (short)n);
            nBTTagCompound2.setShort("lvl", (short)n2);
            bl = true;
        }
        if (!bl) {
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
            nBTTagCompound3.setShort("id", (short)n);
            nBTTagCompound3.setShort("lvl", (short)n2);
            nBTTagList.appendTag((NBTBase)nBTTagCompound3);
        }
        nBTTagCompound.setTag("ench", (NBTBase)nBTTagList);
    }

    public static void addEnchantment(ItemStack itemStack, int n, int n2) {
        CoFHEnchantment.addEnchantment(itemStack.stackTagCompound, n, n2);
    }
}

