/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.crash;

import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CrashHelper {
    static final int range = 3;
    static final char[] validLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz!\u00a3$%^&*()`\u00ac_+\"\\@'{}[]~/|<>,.?:;".toCharArray();
    static final char[] metaLetters = "0123456789ABCDEF".toCharArray();

    public static CrashReport makeDetailedCrashReport(Throwable throwable, String string, Object object, Object ... objectArray) {
        CrashReport crashReport = CrashReport.makeCrashReport((Throwable)throwable, (String)string);
        crashReport.makeCategory("Calling Thread").addCrashSectionCallable("Name", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return Thread.currentThread().getName();
            }
        });
        if (object != null) {
            CrashHelper.addCallSection(object, crashReport, "Calling Object");
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object2 = objectArray[i + 1];
            CrashHelper.addCallSection(object2, crashReport, "Additional - " + objectArray[i]);
        }
        return crashReport;
    }

    public static CrashReport addSurroundingDetails(CrashReport crashReport, String string, TileEntity tileEntity) {
        if (tileEntity == null) {
            CrashReportCategory crashReportCategory = crashReport.makeCategory("Surroundings" + (string == null ? "" : string));
            crashReportCategory.addCrashSection("Tile?", (Object)"Null");
            return crashReport;
        }
        return CrashHelper.addSurroundingDetails(crashReport, string, tileEntity.getWorldObj(), tileEntity.xCoord, tileEntity.yCoord, tileEntity.zCoord);
    }

    public static CrashReport addSurroundingDetails(CrashReport crashReport, String string, final World world, final int n, final int n2, final int n3) {
        CrashReportCategory crashReportCategory = crashReport.makeCategory("Surroundings" + (string == null ? "" : string));
        if (world == null) {
            crashReportCategory.addCrashSection("World", (Object)"Null");
            crashReportCategory.addCrashSection("Pos", (Object)(n + "," + n2 + "," + n3));
            return crashReport;
        }
        crashReportCategory.addCrashSectionCallable("Dim", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return String.valueOf(world.provider.dimensionId);
            }
        });
        crashReportCategory.addCrashSectionCallable("Dim_Name", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "" + world.provider.getDimensionName();
            }
        });
        crashReportCategory.addCrashSection("Pos", (Object)(n + "," + n2 + "," + n3));
        crashReportCategory.addCrashSectionCallable("NeighbourBlocks", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                HashBiMap hashBiMap = HashBiMap.create();
                hashBiMap.put((Object)Blocks.air, (Object)" ");
                StringBuilder stringBuilder = new StringBuilder("\n\n");
                for (int i = -3; i <= 3; ++i) {
                    for (int j = -3; j <= 3; ++j) {
                        stringBuilder.append("\t\t");
                        if (j == -3) {
                            stringBuilder.append("dy = ").append(i);
                        } else {
                            stringBuilder.append("\t");
                        }
                        stringBuilder.append("[ ");
                        for (int k = -3; k <= 3; ++k) {
                            int n5 = n + j;
                            int n22 = n2 + i;
                            int n32 = n3 + k;
                            if (world.blockExists(n5, n22, n32)) {
                                Block block = world.getBlock(n5, n22, n32);
                                stringBuilder.append(this.getNameForObject(block, (HashBiMap<Block, String>)hashBiMap));
                                int n4 = world.getBlockMetadata(n5, n22, n32);
                                if (n4 < 0 || n4 > 15) {
                                    stringBuilder.append('!');
                                } else if (n4 == 0 && block == Blocks.air) {
                                    stringBuilder.append(' ');
                                } else {
                                    stringBuilder.append(metaLetters[n4]);
                                }
                            } else {
                                hashBiMap.put(null, (Object)"X");
                                stringBuilder.append("XX");
                            }
                            stringBuilder.append(" ");
                        }
                        stringBuilder.append(']').append('\n');
                    }
                    stringBuilder.append('\n');
                }
                for (Map.Entry entry : hashBiMap.entrySet()) {
                    stringBuilder.append("\t\t'");
                    stringBuilder.append((String)entry.getValue());
                    stringBuilder.append("': ");
                    Block block = (Block)entry.getKey();
                    if (block == null) {
                        stringBuilder.append("No Block Present");
                    } else {
                        stringBuilder.append(Block.blockRegistry.getNameForObject((Object)block));
                    }
                    stringBuilder.append('\n');
                }
                return stringBuilder.toString();
            }

            public String getNameForObject(Block block, HashBiMap<Block, String> hashBiMap) {
                String string = (String)hashBiMap.get((Object)block);
                if (string != null) {
                    return string;
                }
                String string2 = Block.blockRegistry.getNameForObject((Object)block);
                if (string2 != null && string2.length() > 0) {
                    String string3;
                    int n4 = string2.indexOf(58);
                    if (n4 >= 0) {
                        string2 = string2.substring(n4 + 1, string2.length());
                    }
                    if (!hashBiMap.containsValue((Object)(string3 = string2.substring(0, 1).toUpperCase()))) {
                        hashBiMap.put((Object)block, (Object)string3);
                        return string3;
                    }
                    for (char c : string2.toCharArray()) {
                        if (!Character.isUpperCase(c) || hashBiMap.containsValue((Object)String.valueOf(c))) continue;
                        hashBiMap.put((Object)block, (Object)String.valueOf(c));
                        return String.valueOf(c);
                    }
                    for (char c : string2.toCharArray()) {
                        if (hashBiMap.containsValue((Object)String.valueOf(c))) continue;
                        hashBiMap.put((Object)block, (Object)String.valueOf(c));
                        return String.valueOf(c);
                    }
                }
                for (char c : validLetters) {
                    if (hashBiMap.containsValue((Object)String.valueOf(c))) continue;
                    hashBiMap.put((Object)block, (Object)String.valueOf(c));
                    return String.valueOf(c);
                }
                string = "#" + hashBiMap.size();
                hashBiMap.put((Object)block, (Object)string);
                return string;
            }
        });
        return crashReport;
    }

    public static void addCallSection(final Object object, CrashReport crashReport, String string) {
        CrashReportCategory crashReportCategory = crashReport.makeCategory(string);
        if (object == null) {
            crashReportCategory.addCrashSection("Null?", (Object)"Null");
            return;
        }
        if (object instanceof Enum) {
            crashReportCategory.addCrashSection("Value", (Object)(object.toString() + " . " + ((Enum)object).ordinal()));
            return;
        }
        if (object instanceof Throwable) {
            crashReportCategory.addCrashSectionThrowable("Throwable", (Throwable)object);
            return;
        }
        crashReportCategory.addCrashSectionCallable("Class", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return object.getClass().getName();
            }
        });
        crashReportCategory.addCrashSectionCallable("ToString", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return object.toString();
            }
        });
        if (object instanceof TileEntity) {
            final TileEntity tileEntity = (TileEntity)object;
            tileEntity.func_145828_a(crashReportCategory);
            crashReportCategory.addCrashSectionCallable("Tile Pos", (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return String.format("%d,%d,%d", tileEntity.xCoord, tileEntity.yCoord, tileEntity.zCoord);
                }
            });
            crashReportCategory.addCrashSectionCallable("Tile NBT", (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    NBTTagCompound nBTTagCompound = new NBTTagCompound();
                    tileEntity.writeToNBT(nBTTagCompound);
                    return nBTTagCompound.toString();
                }
            });
        }
    }

    public static void addInventoryContents(CrashReport crashReport, String string, final IInventory iInventory) {
        CrashReportCategory crashReportCategory = crashReport.makeCategory(string);
        if (iInventory == null) {
            crashReportCategory.addCrashSection("Null?", (Object)"Null");
            return;
        }
        crashReportCategory.addCrashSectionCallable("InventoryContents", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                StringBuilder stringBuilder = new StringBuilder("\n\n");
                stringBuilder.append(iInventory.toString()).append(" - ").append(iInventory.getSizeInventory());
                for (int i = 0; i < iInventory.getSizeInventory(); ++i) {
                    ItemStack itemStack;
                    stringBuilder.append(i).append(" - ");
                    try {
                        itemStack = iInventory.getStackInSlot(i);
                    }
                    catch (Exception exception) {
                        stringBuilder.append("Errored - ").append(exception.toString()).append("\n");
                        continue;
                    }
                    stringBuilder.append(itemStack == null ? "Null" : itemStack.toString()).append("\n");
                }
                stringBuilder.append("\n\n");
                return stringBuilder.toString();
            }
        });
    }

    public static CrashReport makeDetailedCrashReport(Exception exception, String string) {
        return CrashHelper.makeDetailedCrashReport(exception, string, null, new Object[0]);
    }
}

