/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.CoFHCore;
import cofh.core.command.ISubCommand;
import com.google.common.base.Throwables;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CommandTPS
implements ISubCommand {
    public static CommandTPS instance = new CommandTPS();
    private static DecimalFormat floatfmt = new DecimalFormat("##0.00");

    private double getTickTimeSum(long[] lArray) {
        long l = 0L;
        if (lArray == null) {
            return 0.0;
        }
        for (int i = 0; i < lArray.length; ++i) {
            l += lArray[i];
        }
        return l / (long)lArray.length;
    }

    private double getTickMs(World world) {
        return this.getTickTimeSum(world == null ? CoFHCore.server.tickTimeArray : (long[])CoFHCore.server.worldTickTimes.get(world.provider.dimensionId)) * 1.0E-6;
    }

    private double getTps(World world) {
        double d = 1000.0 / this.getTickMs(world);
        return d > 20.0 ? 20.0 : d;
    }

    @Override
    public String getCommandName() {
        return "tps";
    }

    @Override
    public int getPermissionLevel() {
        return 0;
    }

    @Override
    public void handleCommand(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length < 2) {
            double d = this.getTps(null);
            double d2 = this.getTickMs(null);
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("Overall: " + floatfmt.format(d) + " TPS/" + floatfmt.format(d2) + "MS (" + (int)(d / 20.0 * 100.0) + "%)"));
            for (WorldServer worldServer : CoFHCore.server.worldServers) {
                d = this.getTps((World)worldServer);
                d2 = this.getTickMs((World)worldServer);
                iCommandSender.addChatMessage((IChatComponent)new ChatComponentText(worldServer.provider.getDimensionName() + " [" + worldServer.provider.dimensionId + "]: " + floatfmt.format(d) + " TPS/" + floatfmt.format(d2) + "MS (" + (int)(d / 20.0 * 100.0) + "%)"));
            }
        } else if (stringArray[1].toLowerCase(Locale.US).charAt(0) == 'o') {
            double d = this.getTickMs(null);
            double d3 = this.getTps(null);
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("Overall server tick"));
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("TPS: " + floatfmt.format(d3) + " TPS of " + floatfmt.format(20L) + " TPS (" + (int)(d3 / 20.0 * 100.0) + "%)"));
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("Tick time: " + floatfmt.format(d) + " ms of " + floatfmt.format(50L) + " ms"));
        } else if (stringArray[1].toLowerCase(Locale.US).charAt(0) == 'a') {
            double d = this.getTickMs(null);
            double d4 = this.getTps(null);
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("Overall server tick"));
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("TPS: " + floatfmt.format(d4) + " TPS of " + floatfmt.format(20L) + " TPS (" + (int)(d4 / 20.0 * 100.0) + "%)"));
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("Tick time: " + floatfmt.format(d) + " ms of " + floatfmt.format(50L) + " ms"));
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (WorldServer worldServer : CoFHCore.server.worldServers) {
                n += worldServer.getChunkProvider().getLoadedChunkCount();
                n2 += worldServer.loadedEntityList.size();
                n3 += worldServer.loadedTileEntityList.size();
                ++n4;
            }
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("Total Loaded Worlds/Chunks: " + n4 + "/" + n));
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("Total Entities/TileEntities: " + n2 + "/" + n3));
        } else {
            int n = 0;
            try {
                n = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[1]);
            }
            catch (Throwable throwable) {
                iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
                iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]));
                Throwables.propagate((Throwable)throwable);
            }
            WorldServer worldServer = CoFHCore.server.worldServerForDimension(n);
            if (worldServer == null) {
                throw new CommandException("info.cofh.command.world.notFound", new Object[0]);
            }
            double d = this.getTickMs((World)worldServer);
            double d5 = this.getTps((World)worldServer);
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("World " + worldServer.provider.dimensionId + ": " + worldServer.provider.getDimensionName() + " - Loaded chunks: " + worldServer.getChunkProvider().getLoadedChunkCount()));
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("TPS: " + floatfmt.format(d5) + "/" + floatfmt.format(20L) + " TPS (" + (int)(d5 / 20.0 * 100.0) + "%) - Tick: " + floatfmt.format(d) + " ms of " + floatfmt.format(50L) + " ms"));
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("Entities: " + worldServer.loadedEntityList.size() + " - Tile entities: " + worldServer.loadedTileEntityList.size()));
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("o");
            arrayList.add("a");
            for (WorldServer worldServer : CoFHCore.server.worldServers) {
                arrayList.add(Integer.toString(worldServer.provider.dimensionId));
            }
            return CommandBase.getListOfStringsMatchingLastWord((String[])stringArray, (String[])arrayList.toArray(new String[]{""}));
        }
        return null;
    }
}

