/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.CoFHCore;
import cofh.core.RegistrySocial;
import cofh.core.command.ISubCommand;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class CommandFriend
implements ISubCommand {
    public static CommandFriend instance = new CommandFriend();

    public boolean validUsername(String string) {
        return string.replaceAll("[a-zA-Z0-9_]", "").matches("");
    }

    @Override
    public String getCommandName() {
        return "friend";
    }

    @Override
    public int getPermissionLevel() {
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handleCommand(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length > 2) {
            EntityPlayerMP entityPlayerMP = CommandBase.getCommandSenderAsPlayer((ICommandSender)iCommandSender);
            if (stringArray[1].equalsIgnoreCase("add")) {
                if (!this.validUsername(stringArray[2])) {
                    iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("\u00a74" + StringHelper.localize("info.cofh.command.friend.3")));
                    return;
                }
                if (RegistrySocial.addFriend(entityPlayerMP.getGameProfile(), stringArray[2])) {
                    iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("\u00a7e" + stringArray[2] + "\u00a72" + " " + StringHelper.localize("info.cofh.command.friend.0")));
                    return;
                }
                iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("\u00a74" + StringHelper.localize("info.cofh.command.friend.1") + " " + "\u00a7e" + stringArray[2] + "\u00a74" + " " + StringHelper.localize("info.cofh.command.friend.2")));
                return;
            }
            if (!stringArray[1].equalsIgnoreCase("remove")) {
                iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
                throw new WrongUsageException("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]);
            }
            if (!this.validUsername(stringArray[2])) {
                iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("\u00a74" + StringHelper.localize("info.cofh.command.friend.3")));
                return;
            }
            if (RegistrySocial.removeFriend(entityPlayerMP.getGameProfile(), stringArray[2])) {
                iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("\u00a7e" + stringArray[2] + "\u00a72" + " " + StringHelper.localize("info.cofh.command.friend.4")));
                return;
            }
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentText("\u00a7e" + stringArray[2] + "\u00a74" + " " + StringHelper.localize("info.cofh.command.friend.5")));
            return;
        }
        if (stringArray.length > 1 && stringArray[1].equalsIgnoreCase("gui")) {
            if (!(iCommandSender instanceof EntityPlayerMP)) return;
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)iCommandSender;
            RegistrySocial.sendFriendsToPlayer(entityPlayerMP);
            entityPlayerMP.openGui((Object)CoFHCore.instance, 1, entityPlayerMP.worldObj, (int)entityPlayerMP.posX, (int)entityPlayerMP.posY, (int)entityPlayerMP.posZ);
            return;
        }
        iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
        throw new WrongUsageException("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]);
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 2) {
            return CommandBase.getListOfStringsMatchingLastWord((String[])stringArray, (String[])new String[]{"add", "remove", "gui"});
        }
        if (stringArray.length == 3) {
            return CommandBase.getListOfStringsMatchingLastWord((String[])stringArray, (String[])MinecraftServer.getServer().getAllUsernames());
        }
        return null;
    }
}

