/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.core.command.CommandHandler;
import cofh.core.command.ISubCommand;
import com.google.common.base.Throwables;
import gnu.trove.iterator.hash.TObjectHashIterator;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class CommandClearBlock
implements ISubCommand {
    public static ISubCommand instance = new CommandClearBlock();

    @Override
    public String getCommandName() {
        return "clearblocks";
    }

    @Override
    public int getPermissionLevel() {
        return 3;
    }

    @Override
    public void handleCommand(ICommandSender iCommandSender, String[] stringArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (stringArray.length < 6) {
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
            throw new WrongUsageException("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]);
        }
        World world = iCommandSender.getEntityWorld();
        if (world.isRemote) {
            return;
        }
        ChunkCoordinates chunkCoordinates = null;
        int n6 = 1;
        if ("@".equals(stringArray[n6])) {
            chunkCoordinates = iCommandSender.getPlayerCoordinates();
            int n7 = ++n6;
            n5 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n7]);
        } else {
            try {
                n5 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n6++]);
            }
            catch (Throwable throwable) {
                chunkCoordinates = CommandBase.getPlayer((ICommandSender)iCommandSender, (String)stringArray[n6 - 1]).getPlayerCoordinates();
                n5 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n6++]);
            }
        }
        int n8 = ++n6;
        int n9 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n8]);
        int n10 = ++n6;
        int n11 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n10]);
        int n12 = ++n6 + 1;
        try {
            n4 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n6++]);
            n3 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n6++]);
            n2 = CommandBase.parseInt((ICommandSender)iCommandSender, (String)stringArray[n6++]);
        }
        catch (Throwable throwable) {
            if (n6 > n12 || chunkCoordinates == null) {
                throw Throwables.propagate((Throwable)throwable);
            }
            --n6;
            n4 = n5;
            n3 = n9;
            n2 = n11;
        }
        if (chunkCoordinates != null) {
            n5 = chunkCoordinates.posX - n5;
            n9 = chunkCoordinates.posY - n9;
            n11 = chunkCoordinates.posZ - n11;
            n4 = chunkCoordinates.posX + n4;
            n3 = chunkCoordinates.posY + n3;
            n2 = chunkCoordinates.posZ + n2;
        }
        n9 &= ~n9 >> 31;
        n3 &= ~n3 >> 31;
        if (n4 < n5) {
            n12 = n5;
            n5 = n4;
            n4 = n12;
        }
        if (n3 < n9) {
            n12 = n9;
            n9 = n3;
            n3 = n12;
        }
        if (n2 < n11) {
            n12 = n11;
            n11 = n2;
            n2 = n12;
        }
        if (n9 > 255) {
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]));
            return;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        long l = ((long)n4 - (long)n5) * ((long)n3 - (long)n9) * ((long)n2 - (long)n11);
        CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.clearblocks.start", l, n5, n9, n11, n4, n3, n2);
        THashSet tHashSet = new THashSet();
        l = 0L;
        int n13 = stringArray.length;
        while (n6 < n13) {
            int n14;
            int n15;
            String string = stringArray[n6];
            if (string.charAt(0) == '*') {
                if (string.equals("*fluid")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n15 = n & 0xF;
                            int n16 = i & 0xF;
                            for (n14 = n9; n14 <= n3; ++n14) {
                                Block block = chunk.getBlock(n15, n14, n16);
                                if (!block.getMaterial().isLiquid() || !chunk.func_150807_a(n15, n14, n16, Blocks.air, 0)) continue;
                                ++l;
                                tHashSet.add((Object)chunk);
                            }
                        }
                    }
                } else if (string.equals("*tree")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n15 = n & 0xF;
                            int n17 = i & 0xF;
                            for (n14 = n9; n14 <= n3; ++n14) {
                                Block block = chunk.getBlock(n15, n14, n17);
                                if (!block.isWood((IBlockAccess)world, n, n14, i) && !block.isLeaves((IBlockAccess)world, n, n14, i)) continue;
                                ++l;
                                if (!chunk.func_150807_a(n15, n14, n17, Blocks.air, 0)) continue;
                                tHashSet.add((Object)chunk);
                            }
                        }
                    }
                } else if (string.startsWith("*repl")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n15 = n & 0xF;
                            int n18 = i & 0xF;
                            for (n14 = n9; n14 <= n3; ++n14) {
                                Block block = chunk.getBlock(n15, n14, n18);
                                if (!block.isReplaceable((IBlockAccess)world, n, n14, i) || !chunk.func_150807_a(n15, n14, n18, Blocks.air, 0)) continue;
                                ++l;
                                tHashSet.add((Object)chunk);
                            }
                        }
                    }
                } else if (string.equals("*stone")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n15 = n & 0xF;
                            int n19 = i & 0xF;
                            for (n14 = n9; n14 <= n3; ++n14) {
                                Block block = chunk.getBlock(n15, n14, n19);
                                if (!block.isReplaceableOreGen(world, n, n14, i, Blocks.stone) && !block.isReplaceableOreGen(world, n, n14, i, Blocks.netherrack) && !block.isReplaceableOreGen(world, n, n14, i, Blocks.end_stone)) continue;
                                ++l;
                                if (!chunk.func_150807_a(n15, n14, n19, Blocks.air, 0)) continue;
                                tHashSet.add((Object)chunk);
                            }
                        }
                    }
                } else if (string.equals("*rock")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n15 = n & 0xF;
                            int n20 = i & 0xF;
                            for (n14 = n9; n14 <= n3; ++n14) {
                                Block block = chunk.getBlock(n15, n14, n20);
                                if (block.getMaterial() != Material.rock || !chunk.func_150807_a(n15, n14, n20, Blocks.air, 0)) continue;
                                ++l;
                                tHashSet.add((Object)chunk);
                            }
                        }
                    }
                } else if (string.equals("*sand")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n15 = n & 0xF;
                            int n21 = i & 0xF;
                            for (n14 = n9; n14 <= n3; ++n14) {
                                Block block = chunk.getBlock(n15, n14, n21);
                                if (block.getMaterial() != Material.sand || !chunk.func_150807_a(n15, n14, n21, Blocks.air, 0)) continue;
                                ++l;
                                tHashSet.add((Object)chunk);
                            }
                        }
                    }
                } else if (string.equals("*dirt")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n15 = n & 0xF;
                            int n22 = i & 0xF;
                            for (n14 = n9; n14 <= n3; ++n14) {
                                Block block = chunk.getBlock(n15, n14, n22);
                                Material material = block.getMaterial();
                                if (material != Material.grass && material != Material.ground && material != Material.clay && material != Material.snow && material != Material.craftedSnow && material != Material.ice && material != Material.packedIce || !chunk.func_150807_a(n15, n14, n22, Blocks.air, 0)) continue;
                                ++l;
                                tHashSet.add((Object)chunk);
                            }
                        }
                    }
                } else if (string.startsWith("*plant")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n15 = n & 0xF;
                            int n23 = i & 0xF;
                            for (n14 = n9; n14 <= n3; ++n14) {
                                Block block = chunk.getBlock(n15, n14, n23);
                                Material material = block.getMaterial();
                                if (material != Material.plants && material != Material.vine && material != Material.cactus && material != Material.leaves || !chunk.func_150807_a(n15, n14, n23, Blocks.air, 0)) continue;
                                ++l;
                                tHashSet.add((Object)chunk);
                            }
                        }
                    }
                } else if (string.equals("*fire")) {
                    for (n = n5; n <= n4; ++n) {
                        for (int i = n11; i <= n2; ++i) {
                            Chunk chunk = world.getChunkFromBlockCoords(n, i);
                            n15 = n & 0xF;
                            int n24 = i & 0xF;
                            for (n14 = n9; n14 <= n3; ++n14) {
                                Block block = chunk.getBlock(n15, n14, n24);
                                Material material = block.getMaterial();
                                if (material != Material.fire && material != Material.lava && !block.isBurning((IBlockAccess)world, n, n14, i) || !chunk.func_150807_a(n15, n14, n24, Blocks.air, 0)) continue;
                                ++l;
                                tHashSet.add((Object)chunk);
                            }
                        }
                    }
                }
            } else {
                Block block;
                n = -1;
                n12 = string.indexOf(35);
                if (n12 > 0) {
                    n = CommandBase.parseInt((ICommandSender)iCommandSender, (String)string.substring(n12 + 1));
                    string = string.substring(0, n12);
                }
                if ((block = Block.getBlockFromName((String)string)) != Blocks.air) {
                    for (int i = n5; i <= n4; ++i) {
                        for (n15 = n11; n15 <= n2; ++n15) {
                            Chunk chunk = world.getChunkFromBlockCoords(i, n15);
                            n14 = i & 0xF;
                            int n25 = n15 & 0xF;
                            for (int j = n9; j <= n3; ++j) {
                                boolean bl;
                                boolean bl2 = bl = n == -1 || chunk.getBlockMetadata(n14, j, n25) == n;
                                if (!bl || chunk.getBlock(n14, j, n25) != block || !chunk.func_150807_a(n14, j, n25, Blocks.air, 0)) continue;
                                ++l;
                                tHashSet.add((Object)chunk);
                            }
                        }
                    }
                }
            }
            ++n6;
        }
        if (!tHashSet.isEmpty()) {
            CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.clearblocks.success", l, n5, n9, n11, n4, n3, n2);
        } else {
            CommandHandler.logAdminCommand(iCommandSender, this, "info.cofh.command.clearblocks.failure", new Object[0]);
        }
        if (world instanceof WorldServer) {
            TObjectHashIterator tObjectHashIterator = tHashSet.iterator();
            n = tHashSet.size();
            for (int i = 0; i < n; ++i) {
                Chunk chunk = (Chunk)tObjectHashIterator.next();
                PlayerManager playerManager = ((WorldServer)world).getPlayerManager();
                if (playerManager == null) {
                    return;
                }
                PlayerManager.PlayerInstance playerInstance = playerManager.getOrCreateChunkWatcher(chunk.xPosition, chunk.zPosition, false);
                if (playerInstance == null) continue;
                playerInstance.sendToAllPlayersWatchingChunk((Packet)new S21PacketChunkData(chunk, false, -1));
            }
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 2) {
            return CommandBase.getListOfStringsMatchingLastWord((String[])stringArray, (String[])MinecraftServer.getServer().getAllUsernames());
        }
        return null;
    }
}

