/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.chat;

import cofh.CoFHCore;
import cofh.core.chat.PacketIndexedChat;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.FakePlayer;

public class ChatHelper {
    public static final int cofhTempChatIndexServer = -661464083;
    public static final int cofhTempChatIndexClient = -1245781222;
    public static final boolean indexChat;

    public static IChatComponent getChatComponent(Object object) {
        if (object instanceof IChatComponent) {
            return (IChatComponent)object;
        }
        if (object instanceof String) {
            return new ChatComponentText((String)object);
        }
        if (object instanceof ItemStack) {
            return ((ItemStack)object).func_151000_E();
        }
        if (object instanceof StatBase) {
            return ((StatBase)object).func_150951_e();
        }
        if (object instanceof Entity) {
            return ((Entity)object).func_145748_c_();
        }
        if (object instanceof ICommandSender) {
            return ((ICommandSender)object).func_145748_c_();
        }
        return new ChatComponentText(String.valueOf(object));
    }

    public static IChatComponent formChatComponent(Object ... objectArray) {
        IChatComponent iChatComponent = ChatHelper.getChatComponent(objectArray[0]);
        int n = objectArray.length;
        for (int i = 1; i < n; ++i) {
            iChatComponent.appendSibling(ChatHelper.getChatComponent(objectArray[i]));
        }
        return iChatComponent;
    }

    public static IChatComponent translate(String string) {
        return new ChatComponentTranslation(string, new Object[0]);
    }

    public static String toJSON(IChatComponent iChatComponent) {
        return IChatComponent.Serializer.func_150696_a((IChatComponent)iChatComponent);
    }

    public static IChatComponent fromJSON(String string) {
        return IChatComponent.Serializer.func_150699_a((String)string);
    }

    public static void sendIndexedChatMessageToPlayer(EntityPlayer entityPlayer, IChatComponent iChatComponent) {
        if (entityPlayer.worldObj == null || entityPlayer instanceof FakePlayer) {
            return;
        }
        if (indexChat) {
            if (!entityPlayer.worldObj.isRemote) {
                PacketHandler.sendTo((PacketBase)new PacketIndexedChat(iChatComponent, -661464083), entityPlayer);
            } else {
                CoFHCore.proxy.addIndexedChatMessage(iChatComponent, -1245781222);
            }
        } else {
            entityPlayer.addChatComponentMessage(iChatComponent);
        }
    }

    public static void sendIndexedChatMessagesToPlayer(EntityPlayer entityPlayer, List<IChatComponent> list) {
        if (entityPlayer.worldObj == null || entityPlayer instanceof FakePlayer) {
            return;
        }
        if (indexChat) {
            for (int i = 0; i < list.size(); ++i) {
                if (!entityPlayer.worldObj.isRemote) {
                    PacketHandler.sendTo((PacketBase)new PacketIndexedChat(list.get(i), -661464083 + i), entityPlayer);
                    continue;
                }
                CoFHCore.proxy.addIndexedChatMessage(list.get(i), -1245781222 + i);
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                entityPlayer.addChatComponentMessage(list.get(i));
            }
        }
    }

    static {
        String string = "gui.chat";
        CoFHCore.configClient.getCategory(string).setComment("The options in this section change core Minecraft behavior and are not limited to CoFH mods.");
        String string2 = "Set to false to disable outdated CoFH info chat messages being removed from chat";
        indexChat = CoFHCore.configClient.get(string, "RemoveOutdatedChat", true, string2);
    }
}

