/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.api.tileentity.ISecurable;
import cofh.core.CoFHProps;
import cofh.core.RegistrySocial;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketCoFHBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTile;
import cofh.core.util.CoreUtils;
import cofh.lib.util.helpers.SecurityHelper;
import cofh.lib.util.helpers.ServerHelper;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;

public abstract class TileCoFHBase
extends TileEntity {
    public void onChunkUnload() {
        if (!this.tileEntityInvalid) {
            this.invalidate();
        }
    }

    public abstract String getName();

    public abstract int getType();

    public void blockBroken() {
    }

    public void blockDismantled() {
        this.blockBroken();
    }

    public void blockPlaced() {
    }

    public void markChunkDirty() {
        this.worldObj.markTileEntityChunkModified(this.xCoord, this.yCoord, this.zCoord, (TileEntity)this);
    }

    public void callNeighborBlockChange() {
        this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
    }

    public void callNeighborTileChange() {
        this.worldObj.func_147453_f(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
    }

    public void onNeighborBlockChange() {
    }

    public void onNeighborTileChange(int n, int n2, int n3) {
    }

    public int getComparatorInput(int n) {
        return 0;
    }

    public int getLightValue() {
        return 0;
    }

    public boolean canPlayerAccess(EntityPlayer entityPlayer) {
        if (!(this instanceof ISecurable)) {
            return true;
        }
        ISecurable.AccessMode accessMode = ((ISecurable)((Object)this)).getAccess();
        String string = entityPlayer.getCommandSenderName();
        if (accessMode.isPublic() || CoFHProps.enableOpSecureAccess && CoreUtils.isOp(string)) {
            return true;
        }
        GameProfile gameProfile = ((ISecurable)((Object)this)).getOwner();
        UUID uUID = gameProfile.getId();
        if (SecurityHelper.isDefaultUUID(uUID)) {
            return true;
        }
        UUID uUID2 = SecurityHelper.getID(entityPlayer);
        if (uUID.equals(uUID2)) {
            return true;
        }
        return accessMode.isRestricted() && RegistrySocial.playerHasAccess(string, gameProfile);
    }

    public boolean canPlayerDismantle(EntityPlayer entityPlayer) {
        return true;
    }

    public boolean isUseable(EntityPlayer entityPlayer) {
        return entityPlayer.getDistanceSq((double)this.xCoord, (double)this.yCoord, (double)this.zCoord) <= 64.0 && this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this;
    }

    public boolean onWrench(EntityPlayer entityPlayer, int n) {
        return false;
    }

    protected final boolean timeCheck() {
        return this.worldObj.getTotalWorldTime() % 32L == 0L;
    }

    protected final boolean timeCheckEighth() {
        return this.worldObj.getTotalWorldTime() % 4L == 0L;
    }

    public Packet getDescriptionPacket() {
        return PacketHandler.toMCPacket(this.getPacket());
    }

    public PacketCoFHBase getPacket() {
        return new PacketTile(this);
    }

    public void sendDescPacket() {
        PacketHandler.sendToAllAround((PacketBase)this.getPacket(), this);
    }

    protected void updateLighting() {
        int n = this.worldObj.getSavedLightValue(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord);
        int n2 = this.getLightValue();
        if (n2 != n && this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord)) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public void sendUpdatePacket(Side side) {
        if (this.worldObj == null) {
            return;
        }
        if (side == Side.CLIENT && ServerHelper.isServerWorld(this.worldObj)) {
            PacketHandler.sendToAllAround((PacketBase)this.getPacket(), this);
        } else if (side == Side.SERVER && ServerHelper.isClientWorld(this.worldObj)) {
            PacketHandler.sendToServer(this.getPacket());
        }
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return null;
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return null;
    }

    public int getInvSlotCount() {
        return 0;
    }

    public boolean openGui(EntityPlayer entityPlayer) {
        return false;
    }

    public void receiveGuiNetworkData(int n, int n2) {
    }

    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
    }
}

