/*
 * Decompiled with CFR 0.152.
 */
package cofh.core;

import cofh.CoFHCore;
import cofh.core.CoFHProps;
import cofh.core.Proxy;
import cofh.core.RegistrySocial;
import cofh.core.entity.EntityCoFHArrow;
import cofh.core.gui.client.GuiFriendsList;
import cofh.core.gui.element.TabAugment;
import cofh.core.gui.element.TabConfiguration;
import cofh.core.gui.element.TabEnergy;
import cofh.core.gui.element.TabInfo;
import cofh.core.gui.element.TabRedstone;
import cofh.core.gui.element.TabSecurity;
import cofh.core.gui.element.TabTutorial;
import cofh.core.key.CoFHKeyHandler;
import cofh.core.render.CoFHFontRenderer;
import cofh.core.render.CustomEffectRenderer;
import cofh.core.render.IconRegistry;
import cofh.core.render.ShaderHelper;
import cofh.core.sided.IFunctionSided;
import cofh.core.sided.IRunnableClient;
import cofh.core.sided.IRunnableServer;
import cofh.core.util.KeyBindingEmpower;
import cofh.core.util.KeyBindingMultiMode;
import cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderArrow;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import org.lwjgl.opengl.EXTFramebufferObject;

@SideOnly(value=Side.CLIENT)
public class ProxyClient
extends Proxy {
    public static CoFHFontRenderer fontRenderer;
    public static final KeyBind KEYBINDING_EMPOWER;
    public static final KeyBind KEYBINDING_MULTIMODE;
    public static final KeyBind KEYBINDING_AUGMENTS;

    @Override
    public void preInit() {
        Minecraft.memoryReserve = null;
        RenderingRegistry.registerEntityRenderingHandler(EntityCoFHArrow.class, (Render)new RenderArrow());
        String string = "Global";
        CoFHCore.configClient.getCategory(string).setComment("The options in this section change core Minecraft behavior and are not limited to CoFH mods.");
        String string2 = "Set to false to disable any particles from spawning in Minecraft.";
        if (!CoFHCore.configClient.get(string, "EnableParticles", true, string2)) {
            CoFHCore.log.info("Replacing EffectRenderer");
            Minecraft.getMinecraft().effectRenderer = new CustomEffectRenderer();
        }
        if (!CoFHCore.configClient.get(string, "EnableRenderSorting", true, string2 = "Set to false to disable chunk sorting during rendering.")) {
            CoFHProps.enableRenderSorting = false;
        }
        if (!CoFHCore.configClient.get(string, "EnableAnimatedTextures", true, string2 = "Set to false to disable all animated textures in Minecraft.")) {
            CoFHProps.enableAnimatedTextures = false;
        }
        if (!CoFHCore.configClient.get(string = "General", "EnableShaderEffects", true, string2 = "Set to false to disable shader effects in CoFH Mods.")) {
            CoFHProps.enableShaderEffects = false;
        }
        if (CoFHCore.configClient.get(string, "EnableColorBlindTextures", false, string2 = "Set to true to use Color Blind Textures in CoFH Mods, where applicable.")) {
            CoFHProps.enableColorBlindTextures = true;
        }
        if (!CoFHCore.configClient.get(string = "Interface", "EnableGUISlotBorders", true, string2 = "Set to true to draw borders on GUI slots in CoFH Mods, where applicable.")) {
            CoFHProps.enableGUISlotBorders = false;
        }
        if (!CoFHCore.configClient.get(string = "Interface.Tooltips", "DisplayHoldShiftForDetail", true, string2 = "Set to false to hide a tooltip prompting you to press Shift for more details on various items.")) {
            StringHelper.displayShiftForDetail = false;
        }
        if (CoFHCore.configClient.get(string, "DisplayContainedItemsAsStackCount", false, string2 = "Set to true to display large item counts as stacks rather than a single quantity.")) {
            StringHelper.displayStackCount = true;
        }
        if (!CoFHCore.configClient.get(string = "Security", "OpsCanAccessSecureBlocksWarning", true, string2 = "Set to false to disable warnings about Ops having access to 'secure' blocks upon logging on to a server.")) {
            CoFHProps.enableOpSecureAccessWarning = false;
        }
        CoFHCore.configClient.save();
        if (!Boolean.parseBoolean(System.getProperty("forge.forceDisplayStencil", "false")) && !Boolean.parseBoolean(System.getProperty("forge.forceNoStencil", "false"))) {
            try {
                if (!Loader.isModLoaded((String)"OpenMods") || ReflectionHelper.findField(OpenGlHelper.class, (String[])new String[]{"field_153212_w"}).getInt(null) != 2) {
                    int n = 8;
                    ReflectionHelper.findField(ForgeHooksClient.class, (String[])new String[]{"stencilBits"}).setInt(null, n);
                    Framebuffer framebuffer = Minecraft.getMinecraft().getFramebuffer();
                    framebuffer.createBindFramebuffer(framebuffer.framebufferWidth, framebuffer.framebufferHeight);
                    block1 : switch (ReflectionHelper.findField(OpenGlHelper.class, (String[])new String[]{"field_153212_w"}).getInt(null)) {
                        case 2: {
                            switch (EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160)) {
                                case 36053: {
                                    break block1;
                                }
                            }
                            n = 0;
                            ReflectionHelper.findField(ForgeHooksClient.class, (String[])new String[]{"stencilBits"}).setInt(null, 0);
                            framebuffer.createBindFramebuffer(framebuffer.framebufferWidth, framebuffer.framebufferHeight);
                            break;
                        }
                    }
                    BitSet bitSet = (BitSet)ReflectionHelper.getPrivateValue(MinecraftForgeClient.class, null, (String[])new String[]{"stencilBits"});
                    bitSet.set(0, n);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void registerKeyBinds() {
        super.registerKeyBinds();
        CoFHKeyHandler.addKeyBind(KeyBindingEmpower.instance);
        CoFHKeyHandler.addKeyBind(KeyBindingMultiMode.instance);
        ClientRegistry.registerKeyBinding((KeyBinding)KEYBINDING_EMPOWER);
        ClientRegistry.registerKeyBinding((KeyBinding)KEYBINDING_MULTIMODE);
    }

    @Override
    public void registerRenderInformation() {
        TabAugment.initialize();
        TabConfiguration.initialize();
        TabEnergy.initialize();
        TabInfo.initialize();
        TabRedstone.initialize();
        TabSecurity.initialize();
        TabTutorial.initialize();
        ShaderHelper.initShaders();
        fontRenderer = new CoFHFontRenderer(Minecraft.getMinecraft().gameSettings, new ResourceLocation("textures/font/ascii.png"), Minecraft.getMinecraft().renderEngine, false);
        if (Minecraft.getMinecraft().gameSettings.language != null) {
            fontRenderer.setUnicodeFlag(Minecraft.getMinecraft().getLanguageManager().isCurrentLocaleUnicode());
            fontRenderer.setBidiFlag(Minecraft.getMinecraft().getLanguageManager().isCurrentLanguageBidirectional());
        }
        ((IReloadableResourceManager)Minecraft.getMinecraft().getResourceManager()).registerReloadListener((IResourceManagerReloadListener)fontRenderer);
        fontRenderer.initSpecialCharacters();
    }

    @Override
    public void registerTickHandlers() {
        super.registerTickHandlers();
    }

    @Override
    public int getKeyBind(String string) {
        if (string.equalsIgnoreCase("cofh.empower")) {
            return KEYBINDING_EMPOWER.getKeyCode();
        }
        if (string.equalsIgnoreCase("cofh.multimode")) {
            return KEYBINDING_MULTIMODE.getKeyCode();
        }
        if (string.equalsIgnoreCase("cofh.augment")) {
            // empty if block
        }
        return -1;
    }

    @Override
    public void addIndexedChatMessage(IChatComponent iChatComponent, int n) {
        if (iChatComponent == null) {
            Minecraft.getMinecraft().ingameGUI.getChatGUI().deleteChatLine(n);
        } else {
            Minecraft.getMinecraft().ingameGUI.getChatGUI().printChatMessageWithOptionalDeletion(iChatComponent, n);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerIcons(TextureStitchEvent.Pre pre) {
        if (pre.map.getTextureType() != 0 && pre.map.getTextureType() == 1) {
            IconRegistry.addIcon("IconAccessFriends", "cofh:icons/Icon_Access_Friends", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconAccessGuild", "cofh:icons/Icon_Access_Guild", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconAccessPrivate", "cofh:icons/Icon_Access_Private", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconAccessPublic", "cofh:icons/Icon_Access_Public", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconAccept", "cofh:icons/Icon_Accept", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconAcceptInactive", "cofh:icons/Icon_Accept_Inactive", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconAugment", "cofh:icons/Icon_Augment", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconButton", "cofh:icons/Icon_Button", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconButtonHighlight", "cofh:icons/Icon_Button_Highlight", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconButtonInactive", "cofh:icons/Icon_Button_Inactive", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconCancel", "cofh:icons/Icon_Cancel", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconCancelInactive", "cofh:icons/Icon_Cancel_Inactive", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconConfig", "cofh:icons/Icon_Config", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconEnergy", "cofh:icons/Icon_Energy", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconNope", "cofh:icons/Icon_Nope", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconInformation", "cofh:icons/Icon_Information", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconTutorial", "cofh:icons/Icon_Tutorial", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconGunpowder", Items.gunpowder.getIconFromDamage(0));
            IconRegistry.addIcon("IconRedstone", Items.redstone.getIconFromDamage(0));
            IconRegistry.addIcon("IconRSTorchOff", "cofh:icons/Icon_RSTorchOff", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconRSTorchOn", "cofh:icons/Icon_RSTorchOn", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconArrowDown0", "cofh:icons/Icon_ArrowDown_Inactive", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconArrowDown1", "cofh:icons/Icon_ArrowDown", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconArrowUp0", "cofh:icons/Icon_ArrowUp_Inactive", (IIconRegister)pre.map);
            IconRegistry.addIcon("IconArrowUp1", "cofh:icons/Icon_ArrowUp", (IIconRegister)pre.map);
        }
    }

    @SubscribeEvent
    public void blockRenderBlockOverlay(RenderBlockOverlayEvent renderBlockOverlayEvent) {
        if (renderBlockOverlayEvent.overlayType == RenderBlockOverlayEvent.OverlayType.BLOCK && !renderBlockOverlayEvent.blockForOverlay.isNormalCube()) {
            renderBlockOverlayEvent.setCanceled(true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void initializeIcons(TextureStitchEvent.Post post) {
    }

    @Override
    public boolean isOp(String string) {
        return true;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public World getClientWorld() {
        return Minecraft.getMinecraft().theWorld;
    }

    @Override
    public EntityPlayer findPlayer(String string) {
        for (Object e : FMLClientHandler.instance().getClient().theWorld.playerEntities) {
            EntityPlayer entityPlayer = (EntityPlayer)e;
            if (!entityPlayer.getCommandSenderName().toLowerCase(Locale.US).equals(string.toLowerCase(Locale.US))) continue;
            return entityPlayer;
        }
        return null;
    }

    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.getMinecraft().thePlayer;
    }

    @Override
    public List<EntityPlayer> getPlayerList() {
        return new LinkedList<EntityPlayer>();
    }

    @Override
    public void updateFriendListGui() {
        if (Minecraft.getMinecraft().currentScreen != null) {
            ((GuiFriendsList)Minecraft.getMinecraft().currentScreen).taFriendsList.textLines = RegistrySocial.clientPlayerFriends;
        }
    }

    @Override
    public float getSoundVolume(int n) {
        if (n > SoundCategory.values().length) {
            return 0.0f;
        }
        return FMLClientHandler.instance().getClient().gameSettings.getSoundLevel(SoundCategory.values()[n]);
    }

    @Override
    public void runServer(IRunnableServer iRunnableServer) {
    }

    @Override
    public void runClient(IRunnableClient iRunnableClient) {
        iRunnableClient.runClient();
    }

    @Override
    public <F, T> T apply(IFunctionSided<F, T> iFunctionSided, F f) {
        return iFunctionSided.applyClient(f);
    }

    static {
        KEYBINDING_EMPOWER = new KeyBind("key.cofh.empower", 47, "key.cofh.category");
        KEYBINDING_MULTIMODE = new KeyBind("key.cofh.multimode", 46, "key.cofh.category");
        KEYBINDING_AUGMENTS = null;
    }

    public static class KeyBind
    extends KeyBinding {
        public KeyBind(String string, int n, String string2) {
            super(string, n, string2);
        }

        public int cofh_conflictCode() {
            return 0;
        }
    }
}

