/*
 * Decompiled with CFR 0.152.
 */
package cofh.asmhooks;

import cofh.asmhooks.event.ModPopulateChunkEvent;
import cofh.core.CoFHProps;
import cofh.core.item.IEqualityOverrideItem;
import cofh.lib.util.helpers.MathHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class HooksCore {
    public static void preGenerateWorld(World world, int n, int n2) {
        MinecraftForge.EVENT_BUS.post((Event)new ModPopulateChunkEvent.Pre(world, n, n2));
    }

    public static void postGenerateWorld(World world, int n, int n2) {
        MinecraftForge.EVENT_BUS.post((Event)new ModPopulateChunkEvent.Post(world, n, n2));
    }

    public static boolean areItemsEqualHook(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack.getItem() != itemStack2.getItem()) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof IEqualityOverrideItem && ((IEqualityOverrideItem)item).isLastHeldItemEqual(itemStack, itemStack2)) {
            return true;
        }
        if (itemStack.isItemStackDamageable() && itemStack.getItemDamage() != itemStack2.getItemDamage()) {
            return false;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)itemStack, (ItemStack)itemStack2);
    }

    public static void stackItems(EntityItem entityItem) {
        if (!CoFHProps.enableItemStacking) {
            return;
        }
        ItemStack itemStack = entityItem.getEntityItem();
        if (itemStack == null || itemStack.stackSize >= itemStack.getMaxStackSize()) {
            return;
        }
        Iterator iterator = entityItem.worldObj.getEntitiesWithinAABB(EntityItem.class, entityItem.boundingBox.expand(0.5, 0.0, 0.5)).iterator();
        while (iterator.hasNext()) {
            entityItem.combineItems((EntityItem)iterator.next());
        }
    }

    public static List getEntityCollisionBoxes(World world, Entity entity, AxisAlignedBB axisAlignedBB) {
        if (!entity.canBePushed()) {
            ArrayList arrayList = world.collidingBoundingBoxes;
            if (arrayList == null) {
                arrayList = world.collidingBoundingBoxes = new ArrayList();
            }
            arrayList.clear();
            int n = MathHelper.floor(axisAlignedBB.minX);
            int n2 = MathHelper.floor(axisAlignedBB.maxX + 1.0);
            int n3 = MathHelper.floor(axisAlignedBB.minY);
            int n4 = MathHelper.floor(axisAlignedBB.maxY + 1.0);
            int n5 = MathHelper.floor(axisAlignedBB.minZ);
            int n6 = MathHelper.floor(axisAlignedBB.maxZ + 1.0);
            for (int i = n; i < n2; ++i) {
                boolean bl = i >= -30000000 & i < 30000000;
                for (int j = n5; j < n6; ++j) {
                    int n7;
                    boolean bl2 = bl & j >= -30000000 & j < 30000000;
                    if (!world.blockExists(i, 64, j)) continue;
                    if (bl2) {
                        for (n7 = n3 - 1; n7 < n4; ++n7) {
                            world.getBlock(i, n7, j).addCollisionBoxesToList(world, i, n7, j, axisAlignedBB, arrayList, entity);
                        }
                        continue;
                    }
                    for (n7 = n3 - 1; n7 < n4; ++n7) {
                        Blocks.bedrock.addCollisionBoxesToList(world, i, n7, j, axisAlignedBB, arrayList, entity);
                    }
                }
            }
            return arrayList;
        }
        return world.getCollidingBoundingBoxes(entity, axisAlignedBB);
    }

    @SideOnly(value=Side.CLIENT)
    public static void tickTextures(ITickable iTickable) {
        if (CoFHProps.enableAnimatedTextures) {
            iTickable.tick();
        }
    }

    public static boolean paneConnectsTo(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        Block block = iBlockAccess.getBlock(n, n2, n3);
        return block.func_149730_j() || block.getMaterial() == Material.glass || block instanceof BlockPane || iBlockAccess.isSideSolid(n, n2, n3, forgeDirection.getOpposite(), false);
    }
}

