/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tweaker;

import WayofTime.alchemicalWizardry.api.items.ShapedBloodOrbRecipe;
import WayofTime.alchemicalWizardry.api.items.ShapelessBloodOrbRecipe;
import WayofTime.alchemicalWizardry.common.tweaker.MTHelper;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.bloodmagic.BloodOrb")
public class BloodOrb {
    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add(false, MTHelper.toStack(output), MTHelper.toShapedObjects(ingredients)));
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add(true, MTHelper.toStack(output), MTHelper.toObjects(ingredients)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(MTHelper.toStack(output)));
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        private IRecipe iRecipe;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            for (IRecipe r : CraftingManager.getInstance().getRecipeList()) {
                if (!(r instanceof ShapedBloodOrbRecipe) && !(r instanceof ShapelessBloodOrbRecipe) || r.getRecipeOutput() == null || !r.getRecipeOutput().isItemEqual(this.output)) continue;
                this.iRecipe = r;
                break;
            }
            CraftingManager.getInstance().getRecipeList().remove(this.iRecipe);
        }

        public boolean canUndo() {
            return CraftingManager.getInstance().getRecipeList() != null && this.iRecipe != null;
        }

        public void undo() {
            CraftingManager.getInstance().getRecipeList().add(this.iRecipe);
        }

        public String describe() {
            return "Removing Blood Orb Recipe for " + this.output.getDisplayName();
        }

        public String describeUndo() {
            return "Restoring Blood Orb Recipe for " + this.output.getDisplayName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        private IRecipe iRecipe;
        private final boolean isShapeless;
        private final ItemStack output;
        private final Object[] recipe;

        public Add(boolean isShapeless, ItemStack output, Object ... recipe) {
            this.isShapeless = isShapeless;
            this.output = output;
            this.recipe = recipe;
        }

        public void apply() {
            this.iRecipe = this.isShapeless ? new ShapelessBloodOrbRecipe(this.output, this.recipe) : new ShapedBloodOrbRecipe(this.output, this.recipe);
            CraftingManager.getInstance().getRecipeList().add(this.iRecipe);
        }

        public boolean canUndo() {
            return CraftingManager.getInstance().getRecipeList() != null;
        }

        public void undo() {
            CraftingManager.getInstance().getRecipeList().remove(this.iRecipe);
        }

        public String describe() {
            return "Adding Blood Orb Recipe for " + this.output.getDisplayName();
        }

        public String describeUndo() {
            return "Removing Blood Orb Recipe for " + this.output.getDisplayName();
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

