/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.alchemy.AlchemicalPotionCreationHandler;
import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipe;
import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipeRegistry;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.IBindingAgent;
import WayofTime.alchemicalWizardry.common.ICatalyst;
import WayofTime.alchemicalWizardry.common.IFillingAgent;
import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import WayofTime.alchemicalWizardry.common.alchemy.CombinedPotionRegistry;
import WayofTime.alchemicalWizardry.common.alchemy.ICombinationalCatalyst;
import WayofTime.alchemicalWizardry.common.items.potion.AlchemyFlask;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraftforge.common.util.ForgeDirection;

public class TEWritingTable
extends TEInventory
implements ISidedInventory {
    public static final int sizeInv = 7;
    private int progress;
    private int amountUsed;
    private int accelerationTime;

    public TEWritingTable() {
        super(7);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.progress = tagCompound.getInteger("progress");
        this.amountUsed = tagCompound.getInteger("amountUsed");
        this.accelerationTime = tagCompound.getInteger("accelerationTime");
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setInteger("progress", this.progress);
        tagCompound.setInteger("amountUsed", this.amountUsed);
        tagCompound.setInteger("accelerationTime", this.accelerationTime);
    }

    @Override
    public String getInventoryName() {
        return "aw.TEWritingTable";
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        switch (i) {
            case 0: {
                if (itemstack == null) break;
                return itemstack.getItem() instanceof IBloodOrb;
            }
        }
        return i != 6;
    }

    public Packet getDescriptionPacket() {
        return NewPacketHandler.getPacket(this);
    }

    public void handlePacketData(int[] intData) {
        if (intData == null) {
            return;
        }
        if (intData.length == 21) {
            for (int i = 0; i < 7; ++i) {
                ItemStack is;
                this.inv[i] = intData[i * 3 + 2] != 0 ? (is = new ItemStack(Item.getItemById((int)intData[i * 3]), intData[i * 3 + 2], intData[i * 3 + 1])) : null;
            }
        }
    }

    public int[] buildIntDataList() {
        int[] sortList = new int[21];
        int pos = 0;
        for (ItemStack is : this.inv) {
            if (is != null) {
                sortList[pos++] = Item.getIdFromItem((Item)is.getItem());
                sortList[pos++] = is.getItemDamage();
                sortList[pos++] = is.stackSize;
                continue;
            }
            sortList[pos++] = 0;
            sortList[pos++] = 0;
            sortList[pos++] = 0;
        }
        return sortList;
    }

    public ItemStack getResultingItemStack() {
        ItemStack[] composedRecipe = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            composedRecipe[i] = this.inv[i + 1];
        }
        return AlchemyRecipeRegistry.getResult(composedRecipe, this.inv[0]);
    }

    public boolean isRecipeValid() {
        return this.getResultingItemStack() != null;
    }

    public int getAmountNeeded(ItemStack bloodOrb) {
        ItemStack[] composedRecipe = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            composedRecipe[i] = this.inv[i + 1];
        }
        return AlchemyRecipeRegistry.getAmountNeeded(composedRecipe, bloodOrb);
    }

    public boolean containsPotionFlask() {
        return this.getPotionFlaskPosition() != -1;
    }

    public int getPotionFlaskPosition() {
        for (int i = 1; i <= 5; ++i) {
            if (this.inv[i] == null || this.inv[i].getItem() instanceof ItemBlock || this.inv[i].getItem() != ModItems.alchemyFlask) continue;
            return i;
        }
        return -1;
    }

    public boolean containsCombinationCatalyst() {
        return this.getCombinationCatalystPosition() != -1;
    }

    public int getCombinationCatalystPosition() {
        for (int i = 1; i <= 5; ++i) {
            if (this.inv[i] == null || !(this.inv[i].getItem() instanceof ICombinationalCatalyst)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsRegisteredPotionIngredient() {
        return this.getRegisteredPotionIngredientPosition() != -1;
    }

    public int getRegisteredPotionIngredientPosition() {
        ItemStack[] composedRecipe = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            composedRecipe[i] = this.inv[i + 1];
        }
        int location = AlchemicalPotionCreationHandler.getRegisteredPotionIngredientPosition(composedRecipe);
        if (location != -1) {
            return location + 1;
        }
        return -1;
    }

    public boolean containsCatalyst() {
        return this.getCatalystPosition() != -1;
    }

    public int getCatalystPosition() {
        for (int i = 0; i < 5; ++i) {
            if (this.inv[i + 1] == null || !(this.inv[i + 1].getItem() instanceof ICatalyst)) continue;
            return i + 1;
        }
        return -1;
    }

    public boolean containsBindingAgent() {
        return this.getBindingAgentPosition() != -1;
    }

    public int getBindingAgentPosition() {
        for (int i = 0; i < 5; ++i) {
            if (this.inv[i + 1] == null || !(this.inv[i + 1].getItem() instanceof IBindingAgent)) continue;
            return i + 1;
        }
        return -1;
    }

    public boolean containsFillingAgent() {
        return this.getFillingAgentPosition() != -1;
    }

    public int getFillingAgentPosition() {
        for (int i = 0; i < 5; ++i) {
            if (this.inv[i + 1] == null || !(this.inv[i + 1].getItem() instanceof IFillingAgent)) continue;
            return i + 1;
        }
        return -1;
    }

    public boolean containsBlankSlate() {
        return this.getBlankSlatePosition() != -1;
    }

    public int getBlankSlatePosition() {
        for (int i = 0; i < 5; ++i) {
            if (this.inv[i + 1] == null || this.inv[i + 1].getItem() != ModItems.blankSlate) continue;
            return i + 1;
        }
        return -1;
    }

    public void updateEntity() {
        int progressNeeded = 100;
        long worldTime = this.worldObj.getWorldTime();
        if (this.worldObj.isRemote) {
            return;
        }
        if (this.accelerationTime > 0) {
            --this.accelerationTime;
        }
        if (this.containsPotionFlask() && this.containsRegisteredPotionIngredient()) {
            if (this.containsCatalyst()) {
                if (this.getStackInSlot(6) == null) {
                    ++this.progress;
                    if (worldTime % 4L == 0L) {
                        SpellHelper.sendIndexedParticleToAllAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 20, this.worldObj.provider.dimensionId, 1, this.xCoord, this.yCoord, this.zCoord);
                    }
                    if (this.progress >= progressNeeded) {
                        ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                        ItemStack ingredientStack = this.inv[this.getRegisteredPotionIngredientPosition()];
                        ItemStack catalystStack = this.inv[this.getCatalystPosition()];
                        if (flaskStack == null || ingredientStack == null || catalystStack == null) {
                            this.progress = 0;
                            if (this.worldObj != null) {
                                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                            }
                            return;
                        }
                        int potionID = AlchemicalPotionCreationHandler.getPotionIDForStack(ingredientStack);
                        int catalystLevel = ((ICatalyst)catalystStack.getItem()).getCatalystLevel();
                        boolean isConcentration = ((ICatalyst)catalystStack.getItem()).isConcentration();
                        if (potionID == -1 || catalystLevel < 0) {
                            this.progress = 0;
                            if (this.worldObj != null) {
                                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                            }
                            return;
                        }
                        if (isConcentration) {
                            ((AlchemyFlask)flaskStack.getItem()).setConcentrationOfPotion(flaskStack, potionID, catalystLevel);
                        } else {
                            ((AlchemyFlask)flaskStack.getItem()).setDurationFactorOfPotion(flaskStack, potionID, catalystLevel);
                        }
                        this.setInventorySlotContents(6, flaskStack);
                        this.decrStackSize(this.getPotionFlaskPosition(), 1);
                        this.decrStackSize(this.getCatalystPosition(), 1);
                        this.decrStackSize(this.getRegisteredPotionIngredientPosition(), 1);
                        this.progress = 0;
                        if (this.worldObj != null) {
                            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                        }
                    }
                }
            } else if (this.containsBindingAgent() && this.getStackInSlot(6) == null) {
                ++this.progress;
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 20, this.worldObj.provider.dimensionId, 1, this.xCoord, this.yCoord, this.zCoord);
                }
                if (this.progress >= progressNeeded) {
                    ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                    ItemStack ingredientStack = this.inv[this.getRegisteredPotionIngredientPosition()];
                    ItemStack agentStack = this.inv[this.getBindingAgentPosition()];
                    if (flaskStack == null || ingredientStack == null || agentStack == null) {
                        this.progress = 0;
                        if (this.worldObj != null) {
                            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                        }
                        return;
                    }
                    int potionEffectNumber = ((AlchemyFlask)flaskStack.getItem()).getNumberOfPotionEffects(flaskStack);
                    int potionID = AlchemicalPotionCreationHandler.getPotionIDForStack(ingredientStack);
                    int tickDuration = AlchemicalPotionCreationHandler.getPotionTickDurationForStack(ingredientStack);
                    float successChance = ((IBindingAgent)agentStack.getItem()).getSuccessRateForPotionNumber(potionEffectNumber);
                    if (potionID == -1) {
                        this.progress = 0;
                        if (this.worldObj != null) {
                            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                        }
                        return;
                    }
                    ((AlchemyFlask)flaskStack.getItem()).addPotionEffect(flaskStack, potionID, tickDuration);
                    if (successChance > this.worldObj.rand.nextFloat()) {
                        this.setInventorySlotContents(6, flaskStack);
                    } else {
                        this.worldObj.createExplosion(null, (double)this.xCoord + 0.5, (double)(this.yCoord + 1), (double)this.zCoord + 0.5, 2.0f, false);
                    }
                    this.decrStackSize(this.getPotionFlaskPosition(), 1);
                    this.decrStackSize(this.getBindingAgentPosition(), 1);
                    this.decrStackSize(this.getRegisteredPotionIngredientPosition(), 1);
                    this.progress = 0;
                    if (this.worldObj != null) {
                        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                    }
                }
            }
        } else if (this.containsBlankSlate() && this.containsPotionFlask()) {
            if (this.getStackInSlot(6) == null) {
                ++this.progress;
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 20, this.worldObj.provider.dimensionId, 1, this.xCoord, this.yCoord, this.zCoord);
                }
                if (this.progress >= progressNeeded) {
                    ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                    ItemStack blankSlate = this.inv[this.getBlankSlatePosition()];
                    if (flaskStack == null || blankSlate == null) {
                        this.progress = 0;
                        if (this.worldObj != null) {
                            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                        }
                        return;
                    }
                    ((AlchemyFlask)flaskStack.getItem()).setIsPotionThrowable(true, flaskStack);
                    this.setInventorySlotContents(6, flaskStack);
                    this.decrStackSize(this.getPotionFlaskPosition(), 1);
                    this.decrStackSize(this.getBlankSlatePosition(), 1);
                    this.progress = 0;
                    if (this.worldObj != null) {
                        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                    }
                }
            }
        } else if (this.containsFillingAgent() && this.containsPotionFlask()) {
            if (this.getStackInSlot(6) == null) {
                ++this.progress;
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 20, this.worldObj.provider.dimensionId, 1, this.xCoord, this.yCoord, this.zCoord);
                }
                if (this.progress >= progressNeeded) {
                    ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                    ItemStack fillingAgent = this.inv[this.getFillingAgentPosition()];
                    if (flaskStack == null || fillingAgent == null) {
                        this.progress = 0;
                        if (this.worldObj != null) {
                            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                        }
                        return;
                    }
                    int potionEffects = ((AlchemyFlask)flaskStack.getItem()).getNumberOfPotionEffects(flaskStack);
                    int potionFillAmount = ((IFillingAgent)fillingAgent.getItem()).getFilledAmountForPotionNumber(potionEffects);
                    flaskStack.setItemDamage(Math.max(0, flaskStack.getItemDamage() - potionFillAmount));
                    this.setInventorySlotContents(6, flaskStack);
                    this.decrStackSize(this.getPotionFlaskPosition(), 1);
                    this.decrStackSize(this.getFillingAgentPosition(), 1);
                    this.progress = 0;
                    if (this.worldObj != null) {
                        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                    }
                }
            }
        } else if (this.containsPotionFlask() && this.containsCombinationCatalyst()) {
            if (this.getStackInSlot(6) == null && CombinedPotionRegistry.hasCombinablePotionEffect(this.inv[this.getPotionFlaskPosition()])) {
                ++this.progress;
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 20, this.worldObj.provider.dimensionId, 1, this.xCoord, this.yCoord, this.zCoord);
                }
                if (this.progress >= progressNeeded) {
                    ItemStack flaskStack = this.inv[this.getPotionFlaskPosition()];
                    ItemStack combinationCatalyst = this.inv[this.getCombinationCatalystPosition()];
                    if (flaskStack == null || combinationCatalyst == null) {
                        this.progress = 0;
                        if (this.worldObj != null) {
                            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                        }
                        return;
                    }
                    ItemStack newFlask = CombinedPotionRegistry.applyPotionEffect(flaskStack);
                    if (newFlask != null) {
                        this.setInventorySlotContents(6, newFlask);
                        this.decrStackSize(this.getPotionFlaskPosition(), 1);
                        this.decrStackSize(this.getCombinationCatalystPosition(), 1);
                        this.progress = 0;
                        if (this.worldObj != null) {
                            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                        }
                    }
                }
            }
        } else {
            if (!this.isRecipeValid()) {
                this.progress = 0;
                return;
            }
            if (this.progress <= 0) {
                this.progress = 0;
                this.amountUsed = this.getAmountNeeded(this.getStackInSlot(0));
                if (this.worldObj != null) {
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                }
            }
            int acceleration = this.getSpeedIncrease();
            if (this.getStackInSlot(6) == null) {
                if (!SoulNetworkHandler.syphonFromNetworkWhileInContainer(this.getStackInSlot(0), this.amountUsed * acceleration)) {
                    return;
                }
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 20, this.worldObj.provider.dimensionId, 1, this.xCoord, this.yCoord, this.zCoord);
                }
                this.progress += acceleration;
                if (this.progress >= progressNeeded) {
                    this.progress = 0;
                    this.setInventorySlotContents(6, this.getResultingItemStack());
                    ItemStack[] composedRecipe = new ItemStack[5];
                    for (int i = 0; i < 5; ++i) {
                        composedRecipe[i] = this.inv[i + 1];
                    }
                    this.decrementSlots(this.getRecipeForItems(composedRecipe, this.inv[0]));
                    if (this.worldObj != null) {
                        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                    }
                }
            } else if (this.getStackInSlot(6).getItem() == this.getResultingItemStack().getItem() && this.getResultingItemStack().stackSize <= this.getStackInSlot(6).getMaxStackSize() - this.getStackInSlot((int)6).stackSize) {
                if (worldTime % 4L == 0L) {
                    SpellHelper.sendIndexedParticleToAllAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 20, this.worldObj.provider.dimensionId, 1, this.xCoord, this.yCoord, this.zCoord);
                }
                if (!SoulNetworkHandler.syphonFromNetworkWhileInContainer(this.getStackInSlot(0), this.amountUsed * acceleration)) {
                    return;
                }
                this.progress += acceleration;
                if (this.progress >= progressNeeded) {
                    this.progress = 0;
                    ItemStack result = this.getResultingItemStack().copy();
                    result.stackSize += this.getStackInSlot((int)6).stackSize;
                    this.setInventorySlotContents(6, result);
                    ItemStack[] composedRecipe = new ItemStack[5];
                    for (int i = 0; i < 5; ++i) {
                        composedRecipe[i] = this.inv[i + 1];
                    }
                    this.decrementSlots(this.getRecipeForItems(composedRecipe, this.inv[0]));
                    if (this.worldObj != null) {
                        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                    }
                }
            }
        }
    }

    public void decrementSlots(ItemStack[] recipe) {
        boolean[] decrementedList = new boolean[]{false, false, false, false, false};
        block0: for (int i = 0; i < Math.min(recipe.length, 5); ++i) {
            ItemStack decStack = recipe[i];
            if (decStack == null) continue;
            for (int j = 0; j < 5; ++j) {
                ItemStack testStack = this.getStackInSlot(j + 1);
                if (testStack == null || !testStack.isItemEqual(decStack) && (testStack.getItem() != decStack.getItem() || decStack.getItemDamage() != Short.MAX_VALUE) || decrementedList[j]) continue;
                if (testStack.getItem().hasContainerItem(testStack)) {
                    this.inv[j + 1] = testStack.getItem().getContainerItem(testStack);
                } else {
                    this.decrStackSize(j + 1, 1);
                }
                decrementedList[j] = true;
                continue block0;
            }
        }
    }

    public ItemStack[] getRecipeForItems(ItemStack[] recipe, ItemStack bloodOrb) {
        if (bloodOrb == null) {
            return null;
        }
        if (!(bloodOrb.getItem() instanceof IBloodOrb)) {
            return null;
        }
        int bloodOrbLevel = ((IBloodOrb)bloodOrb.getItem()).getOrbLevel();
        for (AlchemyRecipe ar : AlchemyRecipeRegistry.recipes) {
            if (!ar.doesRecipeMatch(recipe, bloodOrbLevel)) continue;
            return ar.getRecipe();
        }
        return null;
    }

    public int getSpeedIncrease() {
        return this.accelerationTime > 0 ? 5 : 1;
    }

    public boolean isWorking() {
        return this.progress > 0;
    }

    public void setAccelerationTime(int accelerationTime) {
        this.accelerationTime = accelerationTime;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        switch (dir) {
            case DOWN: {
                return new int[]{6};
            }
        }
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return slot != 6;
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 6;
    }
}

