/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.common.NewPacketHandler;
import WayofTime.alchemicalWizardry.common.block.IOrientable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TEOrientable
extends TileEntity
implements IOrientable {
    protected ForgeDirection inputFace = ForgeDirection.DOWN;
    protected ForgeDirection outputFace = ForgeDirection.UP;

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        this.setInputDirection(ForgeDirection.getOrientation((int)par1NBTTagCompound.getInteger("inputFace")));
        this.setOutputDirection(ForgeDirection.getOrientation((int)par1NBTTagCompound.getInteger("outputFace")));
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setInteger("inputFace", TEOrientable.getIntForForgeDirection(this.getInputDirection()));
        par1NBTTagCompound.setInteger("outputFace", TEOrientable.getIntForForgeDirection(this.getOutputDirection()));
    }

    @Override
    public ForgeDirection getInputDirection() {
        return this.inputFace;
    }

    @Override
    public ForgeDirection getOutputDirection() {
        return this.outputFace;
    }

    @Override
    public void setInputDirection(ForgeDirection direction) {
        this.inputFace = direction;
    }

    @Override
    public void setOutputDirection(ForgeDirection direction) {
        this.outputFace = direction;
    }

    public static int getIntForForgeDirection(ForgeDirection direction) {
        switch (direction) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return 0;
    }

    public Packet getDescriptionPacket() {
        return NewPacketHandler.getPacket(this);
    }

    public boolean isSideRendered(ForgeDirection side) {
        return side.equals((Object)this.getInputDirection()) || side.equals((Object)this.getOutputDirection());
    }

    public String getResourceLocationForMeta(int meta) {
        return "";
    }
}

