/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.common.omega.OmegaParadigm;
import WayofTime.alchemicalWizardry.common.omega.OmegaRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TEMimicBlock
extends TileEntity {
    private ItemStack[] inv = new ItemStack[1];
    public Reagent reagent;
    private int ticksRemaining = 0;

    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, -999, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readFromNBT(packet.func_148857_g());
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readFromNBT(par1NBTTagCompound);
        NBTTagList tagList = par1NBTTagCompound.getTagList("Inventory", 10);
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound tag = tagList.getCompoundTagAt(i);
            byte slot = tag.getByte("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tag);
        }
        this.ticksRemaining = par1NBTTagCompound.getInteger("ticksRemaining");
        this.reagent = ReagentRegistry.getReagentForKey(par1NBTTagCompound.getString("reagent"));
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeToNBT(par1NBTTagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.setByte("Slot", (byte)i);
            this.inv[i].writeToNBT(tag);
            itemList.appendTag((NBTBase)tag);
        }
        par1NBTTagCompound.setTag("Inventory", (NBTBase)itemList);
        par1NBTTagCompound.setInteger("ticksRemaining", this.ticksRemaining);
        par1NBTTagCompound.setString("reagent", ReagentRegistry.getKeyForReagent(this.reagent));
    }

    public void updateEntity() {
        super.updateEntity();
        --this.ticksRemaining;
        if (this.ticksRemaining <= 0) {
            this.returnContainedBlock();
        }
    }

    public static boolean createMimicBlockAtLocation(World world, int x, int y, int z, int duration, Block block, int meta, Reagent reagent) {
        if (block == null) {
            return false;
        }
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity == null && world.isAirBlock(x, y, z)) {
            ItemStack item = new ItemStack(block, 1, meta);
            world.setBlock(x, y, z, ModBlocks.blockMimic);
            TileEntity tile = world.getTileEntity(x, y, z);
            if (tile instanceof TEMimicBlock) {
                ((TEMimicBlock)tile).setContainedItem(item);
                ((TEMimicBlock)tile).setDuration(duration);
                ((TEMimicBlock)tile).reagent = reagent;
                world.markBlockForUpdate(x, y, z);
                return true;
            }
        } else if (tileEntity instanceof TEMimicBlock && ((TEMimicBlock)tileEntity).getBlock() == block && ((TEMimicBlock)tileEntity).getMetaOfMimic() == meta) {
            ((TEMimicBlock)tileEntity).ticksRemaining = Math.max(duration, ((TEMimicBlock)tileEntity).ticksRemaining);
        }
        return false;
    }

    public static boolean createMimicBlockAtLocation(World world, int x, int y, int z, int duration, Block block, int meta) {
        return TEMimicBlock.createMimicBlockAtLocation(world, x, y, z, duration, block, meta);
    }

    public void setDuration(int dur) {
        this.ticksRemaining = dur;
    }

    public void resetDuration(int dur) {
        if (this.ticksRemaining < dur) {
            this.ticksRemaining = dur;
        }
    }

    public void setContainedItem(ItemStack item) {
        this.inv[0] = item;
    }

    public void returnContainedBlock() {
        this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
    }

    public Block getBlock() {
        ItemStack item = this.inv[0];
        if (item != null && item.getItem() instanceof ItemBlock) {
            return ((ItemBlock)item.getItem()).field_150939_a;
        }
        return null;
    }

    public int getMetaOfMimic() {
        ItemStack item = this.inv[0];
        if (item != null) {
            return item.getItemDamage();
        }
        return 0;
    }

    public boolean getBlockEffectWhileInside(Entity entity, int x, int y, int z) {
        OmegaParadigm paradigm;
        if (this.reagent != null && (paradigm = OmegaRegistry.getParadigmForReagent(this.reagent)) != null) {
            return paradigm.getBlockEffectWhileInside(entity, x, y, z);
        }
        return false;
    }
}

