/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.api.sacrifice.IIncense;
import WayofTime.alchemicalWizardry.api.sacrifice.PlayerSacrificeHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEInventory;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.World;

public class TECrucible
extends TEInventory {
    private int radius = 5;
    public float rColour;
    public float gColour;
    public float bColour;
    public int ticksRemaining = 0;
    public int minValue = 0;
    public int maxValue = 0;
    public float incrementValue = 0.0f;
    public int state = 0;

    public TECrucible() {
        super(1);
        float f = 1.0f;
        float f1 = f * 0.6f + 0.4f;
        float f2 = f * f * 0.7f - 0.5f;
        float f3 = f * f * 0.6f - 0.7f;
        this.rColour = f1;
        this.gColour = f2;
        this.bColour = f3;
    }

    public void updateEntity() {
        ItemStack stack;
        if (this.worldObj.isRemote) {
            return;
        }
        boolean stateChanged = false;
        if (this.ticksRemaining <= 0 && (stack = this.getStackInSlot(0)) != null && stack.getItem() instanceof IIncense) {
            IIncense incense = (IIncense)stack.getItem();
            this.rColour = incense.getRedColour(stack);
            this.gColour = incense.getGreenColour(stack);
            this.bColour = incense.getBlueColour(stack);
            this.ticksRemaining = incense.getIncenseDuration(stack);
            this.minValue = incense.getMinLevel(stack);
            this.maxValue = incense.getMaxLevel(stack);
            this.incrementValue = incense.getTickRate(stack);
            --stack.stackSize;
            if (stack.stackSize <= 0) {
                this.setInventorySlotContents(0, null);
            }
            stateChanged = true;
        }
        if (this.ticksRemaining > 0) {
            List<EntityPlayer> playerList = SpellHelper.getPlayersInRange(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, this.radius, this.radius);
            if (playerList != null && !playerList.isEmpty()) {
                boolean allAreGood = true;
                for (EntityPlayer player : playerList) {
                    if (this.ticksRemaining <= 0 || !PlayerSacrificeHandler.incrementIncense(player, this.minValue, this.maxValue, this.incrementValue)) continue;
                    --this.ticksRemaining;
                    if (this.state != 2) {
                        this.state = 2;
                        stateChanged = true;
                    }
                    allAreGood = false;
                }
                if (allAreGood && this.state != 1) {
                    this.state = 1;
                    stateChanged = true;
                }
            } else if (this.state != 0) {
                this.state = 0;
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                this.updateNeighbors();
            }
        } else if (this.state != 0) {
            this.state = 0;
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.updateNeighbors();
        }
        if (stateChanged) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.updateNeighbors();
        }
    }

    private void updateNeighbors() {
        Block block = this.worldObj.getBlock(this.xCoord + 1, this.yCoord, this.zCoord);
        block.onNeighborBlockChange(this.worldObj, this.xCoord + 1, this.yCoord, this.zCoord, block);
        block = this.worldObj.getBlock(this.xCoord - 1, this.yCoord, this.zCoord);
        block.onNeighborBlockChange(this.worldObj, this.xCoord - 1, this.yCoord, this.zCoord, block);
        block = this.worldObj.getBlock(this.xCoord, this.yCoord + 1, this.zCoord);
        block.onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord + 1, this.zCoord, block);
        block = this.worldObj.getBlock(this.xCoord, this.yCoord - 1, this.zCoord);
        block.onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord - 1, this.zCoord, block);
        block = this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord + 1);
        block.onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord, this.zCoord + 1, block);
        block = this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord - 1);
        block.onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord, this.zCoord - 1, block);
    }

    public void spawnClientParticle(World world, int x, int y, int z, Random rand) {
        switch (this.state) {
            case 0: {
                world.spawnParticle("reddust", (double)x + 0.5 + rand.nextGaussian() / 8.0, (double)y + 0.7, (double)z + 0.5 + rand.nextGaussian() / 8.0, 0.15, 0.15, 0.15);
                break;
            }
            case 1: {
                world.spawnParticle("reddust", (double)x + 0.5 + rand.nextGaussian() / 8.0, (double)y + 0.7, (double)z + 0.5 + rand.nextGaussian() / 8.0, 1.0, 1.0, 1.0);
                break;
            }
            case 2: {
                world.spawnParticle("reddust", (double)x + 0.5 + rand.nextGaussian() / 8.0, (double)y + 0.7, (double)z + 0.5 + rand.nextGaussian() / 8.0, (double)this.rColour, (double)this.gColour, (double)this.bColour);
                world.spawnParticle("flame", (double)x + 0.5 + rand.nextGaussian() / 32.0, (double)y + 0.7, (double)z + 0.5 + rand.nextGaussian() / 32.0, 0.0, 0.02, 0.0);
                break;
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setInteger("ticksRemaining", this.ticksRemaining);
        tag.setInteger("minValue", this.minValue);
        tag.setInteger("maxValue", this.maxValue);
        tag.setFloat("increment", this.incrementValue);
        this.writeClientNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.ticksRemaining = tag.getInteger("ticksRemaining");
        this.minValue = tag.getInteger("minValue");
        this.maxValue = tag.getInteger("maxValue");
        this.incrementValue = tag.getFloat("increment");
        this.readClientNBT(tag);
    }

    public void writeClientNBT(NBTTagCompound tag) {
        tag.setFloat("rColour", this.rColour);
        tag.setFloat("gColour", this.gColour);
        tag.setFloat("bColour", this.bColour);
        tag.setInteger("state", this.state);
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.setByte("Slot", (byte)i);
            this.inv[i].writeToNBT(stackTag);
            invList.appendTag((NBTBase)stackTag);
        }
        tag.setTag("Inventory", (NBTBase)invList);
    }

    public void readClientNBT(NBTTagCompound tag) {
        this.rColour = tag.getFloat("rColour");
        this.gColour = tag.getFloat("gColour");
        this.bColour = tag.getFloat("bColour");
        this.state = tag.getInteger("state");
        NBTTagList invList = tag.getTagList("Inventory", 10);
        for (int i = 0; i < invList.tagCount(); ++i) {
            NBTTagCompound stackTag = invList.getCompoundTagAt(i);
            byte slot = stackTag.getByte("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)stackTag);
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeClientNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 90210, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readClientNBT(packet.func_148857_g());
    }

    @Override
    public String getInventoryName() {
        return "TECrucible";
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return stack != null ? stack.getItem() instanceof IIncense : false;
    }

    public int getRSPowerOutput() {
        return this.state == 1 || this.state == 0 ? 0 : 15;
    }
}

