/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainer;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainerInfo;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.common.tileEntity.TEReagentConduit;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TEBellJar
extends TEReagentConduit {
    public TEBellJar() {
        super(1, 16000);
        this.maxConnextions = 1;
        this.affectedByRedstone = false;
    }

    public int getRSPowerOutput() {
        ReagentStack stack;
        ReagentContainer thisTank = this.tanks[0];
        if (thisTank != null && (stack = thisTank.getReagent()) != null) {
            return 15 * stack.amount / thisTank.getCapacity();
        }
        return 0;
    }

    public static ReagentContainerInfo[] getContainerInfoFromItem(ItemStack stack) {
        NBTTagCompound tag;
        if (stack != null && stack.getItem() instanceof ItemBlock && ModBlocks.blockCrystalBelljar == ((ItemBlock)stack.getItem()).field_150939_a && (tag = stack.getTagCompound()) != null) {
            NBTTagList tagList = tag.getTagList("reagentTanks", 10);
            int size = tagList.tagCount();
            ReagentContainer[] tanks = new ReagentContainer[size];
            ReagentContainerInfo[] infos = new ReagentContainerInfo[size];
            for (int i = 0; i < size; ++i) {
                NBTTagCompound savedTag = tagList.getCompoundTagAt(i);
                tanks[i] = ReagentContainer.readFromNBT(savedTag);
                if (tanks[i] == null) continue;
                infos[i] = tanks[i].getInfo();
            }
            return infos;
        }
        return new ReagentContainerInfo[0];
    }

    public void readTankNBTOnPlace(NBTTagCompound tag) {
        NBTTagList tagList = tag.getTagList("reagentTanks", 10);
        int size = tagList.tagCount();
        this.tanks = new ReagentContainer[size];
        for (int i = 0; i < size; ++i) {
            NBTTagCompound savedTag = tagList.getCompoundTagAt(i);
            this.tanks[i] = ReagentContainer.readFromNBT(savedTag);
        }
    }

    public void writeTankNBT(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.tanks.length; ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            if (this.tanks[i] != null) {
                this.tanks[i].writeToNBT(savedTag);
            }
            tagList.appendTag((NBTBase)savedTag);
        }
        tag.setTag("reagentTanks", (NBTBase)tagList);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.hasChanged == 1) {
            Block block = this.worldObj.getBlock(this.xCoord + 1, this.yCoord, this.zCoord);
            block.onNeighborBlockChange(this.worldObj, this.xCoord + 1, this.yCoord, this.zCoord, block);
            block = this.worldObj.getBlock(this.xCoord - 1, this.yCoord, this.zCoord);
            block.onNeighborBlockChange(this.worldObj, this.xCoord - 1, this.yCoord, this.zCoord, block);
            block = this.worldObj.getBlock(this.xCoord, this.yCoord + 1, this.zCoord);
            block.onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord + 1, this.zCoord, block);
            block = this.worldObj.getBlock(this.xCoord, this.yCoord - 1, this.zCoord);
            block.onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord - 1, this.zCoord, block);
            block = this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord + 1);
            block.onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord, this.zCoord + 1, block);
            block = this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord - 1);
            block.onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord, this.zCoord - 1, block);
        }
    }
}

