/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainer;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TEReagentConduit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TEAlchemicCalcinator
extends TEReagentConduit
implements IInventory {
    protected ItemStack[] inv;
    protected ReagentContainer bufferTank = new ReagentContainer(2000);
    protected int bufferTransferRate = 20;
    public int progress;

    public TEAlchemicCalcinator() {
        super(1, 4000);
        this.inv = new ItemStack[2];
        this.tickRate = 20;
        this.maxConnextions = 1;
        this.progress = 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.bufferTransferRate = tag.getInteger("bufferTransferRate");
        this.progress = tag.getInteger("progress");
        NBTTagCompound bufferTankTag = tag.getCompoundTag("bufferTank");
        this.bufferTank = ReagentContainer.readFromNBT(bufferTankTag);
        NBTTagList tagList = tag.getTagList("Inventory", 10);
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound savedTag = tagList.getCompoundTagAt(i);
            this.inv[i] = savedTag.getBoolean("Empty") ? null : ItemStack.loadItemStackFromNBT((NBTTagCompound)savedTag);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setInteger("bufferTransferRate", this.bufferTransferRate);
        tag.setInteger("progress", this.progress);
        NBTTagCompound bufferTankTag = new NBTTagCompound();
        this.bufferTank.writeToNBT(bufferTankTag);
        tag.setTag("bufferTank", (NBTBase)bufferTankTag);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            if (this.inv[i] != null) {
                this.inv[i].writeToNBT(savedTag);
            } else {
                savedTag.setBoolean("Empty", true);
            }
            itemList.appendTag((NBTBase)savedTag);
        }
        tag.setTag("Inventory", (NBTBase)itemList);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.worldObj.isRemote) {
            this.moveBufferToMain();
            this.tickProgress();
        }
    }

    public void moveBufferToMain() {
        ReagentStack amountStack = this.bufferTank.drain(this.bufferTransferRate, false);
        int drainAmount = this.fill(ForgeDirection.UNKNOWN, amountStack, false);
        if (drainAmount > 0) {
            ReagentStack drainedStack = this.bufferTank.drain(drainAmount, true);
            this.fill(ForgeDirection.UNKNOWN, drainedStack, true);
        }
    }

    public void tickProgress() {
        int lpPerTick = 10;
        int ticksPerReagent = 200;
        ItemStack reagentItemStack = this.getStackInSlot(1);
        if (reagentItemStack == null) {
            this.progress = 0;
            return;
        }
        ReagentStack possibleReagent = ReagentRegistry.getReagentStackForItem(reagentItemStack);
        if (possibleReagent == null || !this.canReagentFitBuffer(possibleReagent)) {
            return;
        }
        ItemStack orbStack = this.getStackInSlot(0);
        if (orbStack == null || !(orbStack.getItem() instanceof IBloodOrb)) {
            return;
        }
        if (!SoulNetworkHandler.canSyphonFromOnlyNetwork(orbStack, lpPerTick)) {
            SoulNetworkHandler.causeNauseaToPlayer(orbStack);
            return;
        }
        if (!SoulNetworkHandler.syphonFromNetworkWhileInContainer(orbStack, lpPerTick)) {
            return;
        }
        ++this.progress;
        if (this.worldObj.getWorldTime() % 4L == 0L) {
            SpellHelper.sendIndexedParticleToAllAround(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 20, this.worldObj.provider.dimensionId, 1, this.xCoord, this.yCoord, this.zCoord);
        }
        if (this.progress >= ticksPerReagent) {
            this.progress = 0;
            this.bufferTank.fill(possibleReagent, true);
            this.decrStackSize(1, 1);
        }
    }

    public boolean canReagentFitBuffer(ReagentStack stack) {
        int amount = this.bufferTank.fill(stack, false);
        return amount >= stack.amount;
    }

    @Override
    public void readClientNBT(NBTTagCompound tag) {
        super.readClientNBT(tag);
        NBTTagList tagList = tag.getTagList("reagentTanks", 10);
        int size = tagList.tagCount();
        this.tanks = new ReagentContainer[size];
        for (int i = 0; i < size; ++i) {
            NBTTagCompound savedTag = tagList.getCompoundTagAt(i);
            this.tanks[i] = ReagentContainer.readFromNBT(savedTag);
        }
        NBTTagList invTagList = tag.getTagList("Inventory", 10);
        for (int i = 0; i < invTagList.tagCount(); ++i) {
            NBTTagCompound savedTag = invTagList.getCompoundTagAt(i);
            this.inv[i] = savedTag.getBoolean("Empty") ? null : ItemStack.loadItemStackFromNBT((NBTTagCompound)savedTag);
        }
    }

    @Override
    public void writeClientNBT(NBTTagCompound tag) {
        super.writeClientNBT(tag);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.tanks.length; ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            if (this.tanks[i] != null) {
                this.tanks[i].writeToNBT(savedTag);
            }
            tagList.appendTag((NBTBase)savedTag);
        }
        tag.setTag("reagentTanks", (NBTBase)tagList);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            NBTTagCompound savedTag = new NBTTagCompound();
            if (this.inv[i] != null) {
                this.inv[i].writeToNBT(savedTag);
            } else {
                savedTag.setBoolean("Empty", true);
            }
            itemList.appendTag((NBTBase)savedTag);
        }
        tag.setTag("Inventory", (NBTBase)itemList);
    }

    @Override
    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeClientNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, -999, nbttagcompound);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.readClientNBT(packet.func_148857_g());
    }

    public int getSizeInventory() {
        return this.inv.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv[slot];
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public ItemStack decrStackSize(int slot, int amt) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            if (stack.stackSize <= amt) {
                this.setInventorySlotContents(slot, null);
            } else {
                stack = stack.splitStack(amt);
                if (stack.stackSize == 0) {
                    this.setInventorySlotContents(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            this.setInventorySlotContents(slot, null);
        }
        return stack;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) == this && player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) < 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public String getInventoryName() {
        return "AlchemicCalcinator";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemStack) {
        return true;
    }

    @Override
    public int fill(ForgeDirection from, ReagentStack resource, boolean doFill) {
        if (doFill && !this.worldObj.isRemote) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
        return super.fill(from, resource, doFill);
    }
}

