/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.simple;

import WayofTime.alchemicalWizardry.common.entity.projectile.WindGustProjectile;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.spell.simple.HomSpell;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SpellWindGust
extends HomSpell {
    Random itemRand = new Random();

    public SpellWindGust() {
        this.setEnergies(300, 400, 300, 500);
    }

    @Override
    public ItemStack onOffensiveRangedRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveRangedEnergy());
        }
        par2World.playSoundAtEntity((Entity)par3EntityPlayer, "random.fizz", 0.5f, 0.4f / (this.itemRand.nextFloat() * 0.4f + 0.8f));
        if (!par2World.isRemote) {
            par2World.spawnEntityInWorld((Entity)new WindGustProjectile(par2World, (EntityLivingBase)par3EntityPlayer, 8));
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onOffensiveMeleeRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveMeleeEnergy());
        }
        int distance = 3;
        double yaw = (double)(par3EntityPlayer.rotationYaw / 180.0f) * Math.PI;
        double pitch = (double)(par3EntityPlayer.rotationPitch / 180.0f) * Math.PI;
        double xCoord = par3EntityPlayer.posX + Math.sin(yaw) * Math.cos(pitch) * (double)(-distance);
        double yCoord = par3EntityPlayer.posY + (double)par3EntityPlayer.getEyeHeight() + Math.sin(-pitch) * (double)distance;
        double zCoord = par3EntityPlayer.posZ + Math.cos(yaw) * Math.cos(pitch) * (double)distance;
        float d0 = 0.5f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBox((double)(par3EntityPlayer.posX - 0.5 + Math.sin(yaw) * Math.cos(pitch) * (double)(-distance)), (double)(par3EntityPlayer.posY + (double)par3EntityPlayer.getEyeHeight() + Math.sin(-pitch) * (double)distance), (double)(par3EntityPlayer.posZ - 0.5 + Math.cos(yaw) * Math.cos(pitch) * (double)distance), (double)(par3EntityPlayer.posX + Math.sin(yaw) * Math.cos(pitch) * (double)(-distance) + 0.5), (double)(par3EntityPlayer.posY + (double)par3EntityPlayer.getEyeHeight() + Math.sin(-pitch) * (double)distance + 1.0), (double)(par3EntityPlayer.posZ + Math.cos(yaw) * Math.cos(pitch) * (double)distance + 0.5)).expand((double)d0, (double)d0, (double)d0);
        List list = par3EntityPlayer.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
        for (EntityLivingBase entityLiving : list) {
            if (entityLiving instanceof EntityPlayer && entityLiving.equals((Object)par3EntityPlayer)) continue;
            entityLiving.motionX = Math.sin(-yaw) * 2.0;
            entityLiving.motionY = 2.0;
            entityLiving.motionZ = Math.cos(yaw) * 2.0;
        }
        for (int i = 0; i < 5; ++i) {
            SpellHelper.sendParticleToAllAround(par2World, xCoord, yCoord, zCoord, 30, par2World.provider.dimensionId, "mobSpell", xCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), yCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), zCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), 0.0, 0.41f, 1.0);
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onDefensiveRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getDefensiveEnergy());
        }
        double yaw = (double)(par3EntityPlayer.rotationYaw / 180.0f) * Math.PI;
        double pitch = (double)(par3EntityPlayer.rotationPitch / 180.0f) * Math.PI;
        double wantedVelocity = 5.0;
        double xVel = Math.sin(yaw) * Math.cos(pitch) * -wantedVelocity;
        double yVel = Math.sin(-pitch) * wantedVelocity;
        double zVel = Math.cos(yaw) * Math.cos(pitch) * wantedVelocity;
        Vec3 vec = par3EntityPlayer.getLookVec();
        par3EntityPlayer.motionX = vec.xCoord * wantedVelocity;
        par3EntityPlayer.motionY = vec.yCoord * wantedVelocity;
        par3EntityPlayer.motionZ = vec.zCoord * wantedVelocity;
        SpellHelper.setPlayerSpeedFromServer(par3EntityPlayer, xVel, yVel, zVel);
        par2World.playSoundEffect((double)((float)par3EntityPlayer.posX + 0.5f), (double)((float)par3EntityPlayer.posY + 0.5f), (double)((float)par3EntityPlayer.posZ + 0.5f), "random.fizz", 0.5f, 2.6f + (par2World.rand.nextFloat() - par2World.rand.nextFloat()) * 0.8f);
        par3EntityPlayer.fallDistance = 0.0f;
        double xCoord = par3EntityPlayer.posX;
        double yCoord = par3EntityPlayer.posY;
        double zCoord = par3EntityPlayer.posZ;
        for (int i = 0; i < 8; ++i) {
            SpellHelper.sendParticleToAllAround(par2World, xCoord, yCoord, zCoord, 30, par2World.provider.dimensionId, "mobSpell", xCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), yCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), zCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), 0.0, 0.41f, 1.0);
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onEnvironmentalRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getEnvironmentalEnergy());
        }
        int d0 = 3;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBox((double)par3EntityPlayer.posX, (double)par3EntityPlayer.posY, (double)par3EntityPlayer.posZ, (double)(par3EntityPlayer.posX + 1.0), (double)(par3EntityPlayer.posY + 2.0), (double)(par3EntityPlayer.posZ + 1.0)).expand((double)d0, (double)d0, (double)d0);
        List list = par3EntityPlayer.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
        Iterator iterator = list.iterator();
        double xCoord = par3EntityPlayer.posX;
        double yCoord = par3EntityPlayer.posY;
        double zCoord = par3EntityPlayer.posZ;
        double wantedVel = 2.0;
        while (iterator.hasNext()) {
            EntityLivingBase entityLiving = (EntityLivingBase)iterator.next();
            if (entityLiving instanceof EntityPlayer && entityLiving.equals((Object)par3EntityPlayer)) continue;
            double posXDif = entityLiving.posX - par3EntityPlayer.posX;
            double posYDif = entityLiving.posY - par3EntityPlayer.posY + 1.0;
            double posZDif = entityLiving.posZ - par3EntityPlayer.posZ;
            double distance2 = Math.pow(posXDif, 2.0) + Math.pow(posYDif, 2.0) + Math.pow(posZDif, 2.0);
            double distance = Math.sqrt(distance2);
            entityLiving.motionX = posXDif * wantedVel / distance;
            entityLiving.motionY = posYDif * wantedVel / distance;
            entityLiving.motionZ = posZDif * wantedVel / distance;
        }
        for (int i = 0; i < 20; ++i) {
            SpellHelper.sendParticleToAllAround(par2World, xCoord, yCoord, zCoord, 30, par2World.provider.dimensionId, "mobSpell", xCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), yCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), zCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), 0.0, 0.41f, 1.0);
        }
        return par1ItemStack;
    }
}

