/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.simple;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.entity.projectile.WaterProjectile;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.spell.simple.HomSpell;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class SpellWateryGrave
extends HomSpell {
    Random itemRand = new Random();

    public SpellWateryGrave() {
        this.setEnergies(250, 350, 500, 750);
    }

    @Override
    public ItemStack onOffensiveRangedRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveRangedEnergy());
        }
        par2World.spawnEntityInWorld((Entity)new WaterProjectile(par2World, (EntityLivingBase)par3EntityPlayer, 8));
        par2World.playSoundAtEntity((Entity)par3EntityPlayer, "random.fizz", 0.5f, 0.4f / (this.itemRand.nextFloat() * 0.4f + 0.8f));
        return par1ItemStack;
    }

    @Override
    public ItemStack onOffensiveMeleeRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveMeleeEnergy());
        }
        if (!par2World.isRemote) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    par2World.spawnEntityInWorld((Entity)new WaterProjectile(par2World, (EntityLivingBase)par3EntityPlayer, 3, 3, par3EntityPlayer.posX, par3EntityPlayer.posY + (double)par3EntityPlayer.getEyeHeight(), par3EntityPlayer.posZ, par3EntityPlayer.rotationYaw + (float)i * 10.0f, par3EntityPlayer.rotationPitch + (float)j * 5.0f));
                }
            }
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onDefensiveRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getDefensiveEnergy());
        }
        int d0 = 3;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBox((double)par3EntityPlayer.posX, (double)par3EntityPlayer.posY, (double)par3EntityPlayer.posZ, (double)(par3EntityPlayer.posX + 1.0), (double)(par3EntityPlayer.posY + 2.0), (double)(par3EntityPlayer.posZ + 1.0)).expand((double)d0, (double)d0, (double)d0);
        List list = par3EntityPlayer.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
        for (EntityLivingBase entityLiving : list) {
            if (entityLiving instanceof EntityPlayer && entityLiving.equals((Object)par3EntityPlayer)) continue;
            int x = 1;
            if (entityLiving.isImmuneToFire()) {
                x = 2;
            }
            entityLiving.attackEntityFrom(DamageSource.drown, (float)(2 * x));
            entityLiving.addPotionEffect(new PotionEffect(AlchemicalWizardry.customPotionDrowning.id, 100, x - 1));
        }
        double xCoord = par3EntityPlayer.posX;
        double yCoord = par3EntityPlayer.posY;
        double zCoord = par3EntityPlayer.posZ;
        for (int i = 0; i < 20; ++i) {
            SpellHelper.sendParticleToAllAround(par2World, xCoord, yCoord, zCoord, 30, par2World.provider.dimensionId, "mobSpell", xCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), yCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), zCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), 0.0, 0.41f, 1.0);
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onEnvironmentalRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getEnvironmentalEnergy());
        }
        int range = 2;
        if (!par2World.isRemote) {
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    if (!par2World.isAirBlock((int)par3EntityPlayer.posX + i, (int)par3EntityPlayer.posY, (int)par3EntityPlayer.posZ + j)) continue;
                    par2World.setBlock((int)par3EntityPlayer.posX + i, (int)par3EntityPlayer.posY, (int)par3EntityPlayer.posZ + j, Blocks.water);
                }
            }
        }
        double xCoord = par3EntityPlayer.posX;
        double yCoord = par3EntityPlayer.posY;
        double zCoord = par3EntityPlayer.posZ;
        for (int i = 0; i < 16; ++i) {
            SpellHelper.sendParticleToAllAround(par2World, xCoord, yCoord, zCoord, 30, par2World.provider.dimensionId, "mobSpell", xCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), yCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), zCoord + (double)((this.itemRand.nextFloat() - this.itemRand.nextFloat()) * 3.0f), 0.0, 0.41f, 1.0);
        }
        return par1ItemStack;
    }
}

