/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.simple;

import WayofTime.alchemicalWizardry.common.entity.projectile.LightningBoltProjectile;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.spell.simple.HomSpell;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class SpellLightningBolt
extends HomSpell {
    Random itemRand = new Random();

    public SpellLightningBolt() {
        this.setEnergies(75, 200, 700, 700);
    }

    @Override
    public ItemStack onOffensiveRangedRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveRangedEnergy());
        }
        par2World.playSoundAtEntity((Entity)par3EntityPlayer, "random.fizz", 0.5f, 0.4f / (this.itemRand.nextFloat() * 0.4f + 0.8f));
        if (!par2World.isRemote) {
            par2World.spawnEntityInWorld((Entity)new LightningBoltProjectile(par2World, (EntityLivingBase)par3EntityPlayer, 8, false));
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onOffensiveMeleeRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveMeleeEnergy());
        }
        double xCoord = par3EntityPlayer.posX;
        double yCoord = par3EntityPlayer.posY;
        double zCoord = par3EntityPlayer.posZ;
        par2World.getWorldInfo().setRaining(true);
        if (par2World.isRemote) {
            par2World.setRainStrength(1.0f);
            par2World.setThunderStrength(1.0f);
        }
        par2World.getWorldInfo().setThunderTime(0);
        par2World.getWorldInfo().setThundering(true);
        for (int i = 0; i < 5; ++i) {
            SpellHelper.sendParticleToAllAround(par2World, xCoord, yCoord, zCoord, 30, par2World.provider.dimensionId, "mobSpell", xCoord + (double)this.itemRand.nextFloat() - (double)this.itemRand.nextFloat(), yCoord + (double)this.itemRand.nextFloat() - (double)this.itemRand.nextFloat(), zCoord + (double)this.itemRand.nextFloat() - (double)this.itemRand.nextFloat(), 1.0, 1.0, 1.0);
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onDefensiveRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        int i;
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getDefensiveEnergy());
        }
        double xCoord = par3EntityPlayer.posX;
        double yCoord = par3EntityPlayer.posY;
        double zCoord = par3EntityPlayer.posZ;
        for (i = 0; i < 5; ++i) {
            par2World.addWeatherEffect((Entity)new EntityLightningBolt(par2World, xCoord + (double)this.itemRand.nextInt(64) - 32.0, yCoord + (double)this.itemRand.nextInt(8) - 8.0, zCoord + (double)this.itemRand.nextInt(64) - 32.0));
        }
        for (i = 0; i < 8; ++i) {
            SpellHelper.sendParticleToAllAround(par2World, xCoord, yCoord, zCoord, 30, par2World.provider.dimensionId, "mobSpell", xCoord + (double)this.itemRand.nextFloat() - (double)this.itemRand.nextFloat(), yCoord + (double)this.itemRand.nextFloat() - (double)this.itemRand.nextFloat(), zCoord + (double)this.itemRand.nextFloat() - (double)this.itemRand.nextFloat(), 1.0, 1.0, 1.0);
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onEnvironmentalRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getEnvironmentalEnergy());
        }
        if (!par2World.isRemote) {
            par2World.spawnEntityInWorld((Entity)new LightningBoltProjectile(par2World, (EntityLivingBase)par3EntityPlayer, 8, true));
        }
        return par1ItemStack;
    }
}

