/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.simple;

import WayofTime.alchemicalWizardry.common.entity.projectile.HolyProjectile;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.spell.simple.HomSpell;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class SpellHolyBlast
extends HomSpell {
    Random itemRand = new Random();

    public SpellHolyBlast() {
        this.setEnergies(100, 300, 500, 400);
    }

    @Override
    public ItemStack onOffensiveRangedRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveRangedEnergy());
        }
        par2World.playSoundAtEntity((Entity)par3EntityPlayer, "random.fizz", 0.5f, 0.4f / (this.itemRand.nextFloat() * 0.4f + 0.8f));
        if (!par2World.isRemote) {
            par2World.spawnEntityInWorld((Entity)new HolyProjectile(par2World, (EntityLivingBase)par3EntityPlayer, 8));
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onOffensiveMeleeRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveMeleeEnergy());
        }
        int distance = 2;
        double yaw = (double)(par3EntityPlayer.rotationYaw / 180.0f) * Math.PI;
        double pitch = (double)(par3EntityPlayer.rotationPitch / 180.0f) * Math.PI;
        double xCoord = par3EntityPlayer.posX + Math.sin(yaw) * Math.cos(pitch) * (double)(-distance);
        double yCoord = par3EntityPlayer.posY + (double)par3EntityPlayer.getEyeHeight() + Math.sin(-pitch) * (double)distance;
        double zCoord = par3EntityPlayer.posZ + Math.cos(yaw) * Math.cos(pitch) * (double)distance;
        float d0 = 0.5f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBox((double)(par3EntityPlayer.posX - 0.5 + Math.sin(yaw) * Math.cos(pitch) * (double)(-distance)), (double)(par3EntityPlayer.posY + (double)par3EntityPlayer.getEyeHeight() + Math.sin(-pitch) * (double)distance), (double)(par3EntityPlayer.posZ - 0.5 + Math.cos(yaw) * Math.cos(pitch) * (double)distance), (double)(par3EntityPlayer.posX + Math.sin(yaw) * Math.cos(pitch) * (double)(-distance) + 0.5), (double)(par3EntityPlayer.posY + (double)par3EntityPlayer.getEyeHeight() + Math.sin(-pitch) * (double)distance + 1.0), (double)(par3EntityPlayer.posZ + Math.cos(yaw) * Math.cos(pitch) * (double)distance + 0.5)).expand((double)d0, (double)d0, (double)d0);
        List list = par3EntityPlayer.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
        for (EntityLivingBase entityLiving : list) {
            if (entityLiving instanceof EntityPlayer && entityLiving.equals((Object)par3EntityPlayer)) continue;
            int i = 1;
            if (entityLiving.isEntityUndead()) {
                i = 3;
            }
            entityLiving.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)par3EntityPlayer), (float)(5 * i));
        }
        par2World.createExplosion((Entity)par3EntityPlayer, xCoord, yCoord, zCoord, 1.0f, false);
        for (int i = 0; i < 5; ++i) {
            SpellHelper.sendParticleToAllAround(par2World, xCoord, yCoord, zCoord, 30, par2World.provider.dimensionId, "mobSpell", xCoord + (double)this.itemRand.nextFloat() - (double)this.itemRand.nextFloat(), yCoord + (double)this.itemRand.nextFloat() - (double)this.itemRand.nextFloat(), zCoord + (double)this.itemRand.nextFloat() - (double)this.itemRand.nextFloat(), 1.0, 1.0, 1.0);
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onDefensiveRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getDefensiveEnergy());
        }
        if (!par2World.isRemote) {
            for (int i = 0; i < 360; i += 18) {
                par2World.spawnEntityInWorld((Entity)new HolyProjectile(par2World, (EntityLivingBase)par3EntityPlayer, 8, 3, par3EntityPlayer.posX, par3EntityPlayer.posY + (double)(par3EntityPlayer.height / 2.0f), par3EntityPlayer.posZ, i, 0.0f));
            }
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onEnvironmentalRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getEnvironmentalEnergy());
        }
        int d0 = 3;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBox((double)par3EntityPlayer.posX, (double)par3EntityPlayer.posY, (double)par3EntityPlayer.posZ, (double)(par3EntityPlayer.posX + 1.0), (double)(par3EntityPlayer.posY + 2.0), (double)(par3EntityPlayer.posZ + 1.0)).expand((double)d0, (double)d0, (double)d0);
        List list = par3EntityPlayer.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, axisalignedbb);
        for (EntityLivingBase entityLiving : list) {
            if (entityLiving instanceof EntityPlayer && entityLiving.equals((Object)par3EntityPlayer)) continue;
            int i = 1;
            if (entityLiving.isEntityUndead()) {
                i = 3;
            }
            entityLiving.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)par3EntityPlayer), (float)(5 * i));
        }
        par2World.createExplosion((Entity)par3EntityPlayer, par3EntityPlayer.posX, par3EntityPlayer.posY, par3EntityPlayer.posZ, 2.0f, false);
        double xCoord = par3EntityPlayer.posX;
        double yCoord = par3EntityPlayer.posY;
        double zCoord = par3EntityPlayer.posZ;
        for (int i = 0; i < 20; ++i) {
            SpellHelper.sendParticleToAllAround(par2World, xCoord, yCoord, zCoord, 30, par2World.provider.dimensionId, "mobSpell", xCoord + (double)this.itemRand.nextFloat() - (double)this.itemRand.nextFloat(), yCoord + (double)this.itemRand.nextFloat() - (double)this.itemRand.nextFloat(), zCoord + (double)this.itemRand.nextFloat() - (double)this.itemRand.nextFloat(), 1.0, 1.0, 1.0);
        }
        return par1ItemStack;
    }
}

