/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.simple;

import WayofTime.alchemicalWizardry.common.entity.projectile.IceProjectile;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.simple.HomSpell;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class SpellFrozenWater
extends HomSpell {
    public Random itemRand = new Random();

    public SpellFrozenWater() {
        this.setEnergies(100, 200, 150, 100);
    }

    @Override
    public ItemStack onOffensiveRangedRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveRangedEnergy());
        }
        par2World.playSoundAtEntity((Entity)par3EntityPlayer, "random.fizz", 0.5f, 0.4f / (this.itemRand.nextFloat() * 0.4f + 0.8f));
        if (!par2World.isRemote) {
            par2World.spawnEntityInWorld((Entity)new IceProjectile(par2World, (EntityLivingBase)par3EntityPlayer, 6));
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onOffensiveMeleeRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getOffensiveMeleeEnergy());
        }
        for (int i = -2; i <= 2; ++i) {
            par2World.spawnEntityInWorld((Entity)new IceProjectile(par2World, (EntityLivingBase)par3EntityPlayer, 6, 2, par3EntityPlayer.posX, par3EntityPlayer.posY + (double)par3EntityPlayer.getEyeHeight(), par3EntityPlayer.posZ, par3EntityPlayer.rotationYaw + (float)i * 5.0f, par3EntityPlayer.rotationPitch));
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onDefensiveRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!par3EntityPlayer.capabilities.isCreativeMode) {
            EnergyItems.syphonAndDamageWhileInContainer(par1ItemStack, par3EntityPlayer, this.getDefensiveEnergy());
        }
        float yaw = par3EntityPlayer.rotationYaw;
        float pitch = par3EntityPlayer.rotationPitch;
        int range = 2;
        if (pitch > 40.0f) {
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    if (!par2World.isAirBlock((int)par3EntityPlayer.posX + i, (int)par3EntityPlayer.posY - 1, (int)par3EntityPlayer.posZ + j)) continue;
                    par2World.setBlock((int)par3EntityPlayer.posX + i, (int)par3EntityPlayer.posY - 1, (int)par3EntityPlayer.posZ + j, Blocks.ice);
                }
            }
            return par1ItemStack;
        }
        if (pitch < -40.0f) {
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    if (!par2World.isAirBlock((int)par3EntityPlayer.posX + i, (int)par3EntityPlayer.posY + 3, (int)par3EntityPlayer.posZ + j)) continue;
                    par2World.setBlock((int)par3EntityPlayer.posX + i, (int)par3EntityPlayer.posY + 3, (int)par3EntityPlayer.posZ + j, Blocks.ice);
                }
            }
            return par1ItemStack;
        }
        if (yaw >= 315.0f && yaw < 360.0f || yaw >= 0.0f && yaw < 45.0f) {
            for (int i = -range; i <= range; ++i) {
                for (int j = 0; j < range * 2 + 1; ++j) {
                    if (!par2World.isAirBlock((int)par3EntityPlayer.posX + i, (int)par3EntityPlayer.posY + j, (int)par3EntityPlayer.posZ + 2)) continue;
                    par2World.setBlock((int)par3EntityPlayer.posX + i, (int)par3EntityPlayer.posY + j, (int)par3EntityPlayer.posZ + 2, Blocks.ice);
                }
            }
        } else if (yaw >= 45.0f && yaw < 135.0f) {
            for (int i = -range; i <= range; ++i) {
                for (int j = 0; j < range * 2 + 1; ++j) {
                    if (!par2World.isAirBlock((int)par3EntityPlayer.posX - 2, (int)par3EntityPlayer.posY + j, (int)par3EntityPlayer.posZ + i)) continue;
                    par2World.setBlock((int)par3EntityPlayer.posX - 2, (int)par3EntityPlayer.posY + j, (int)par3EntityPlayer.posZ + i, Blocks.ice);
                }
            }
        } else if (yaw >= 135.0f && yaw < 225.0f) {
            for (int i = -range; i <= range; ++i) {
                for (int j = 0; j < range * 2 + 1; ++j) {
                    if (!par2World.isAirBlock((int)par3EntityPlayer.posX + i, (int)par3EntityPlayer.posY + j, (int)par3EntityPlayer.posZ - 2)) continue;
                    par2World.setBlock((int)par3EntityPlayer.posX + i, (int)par3EntityPlayer.posY + j, (int)par3EntityPlayer.posZ - 2, Blocks.ice);
                }
            }
        } else {
            for (int i = -range; i <= range; ++i) {
                for (int j = 0; j < range * 2 + 1; ++j) {
                    if (!par2World.isAirBlock((int)par3EntityPlayer.posX + 2, (int)par3EntityPlayer.posY + j, (int)par3EntityPlayer.posZ + i)) continue;
                    par2World.setBlock((int)par3EntityPlayer.posX + 2, (int)par3EntityPlayer.posY + j, (int)par3EntityPlayer.posZ + i, Blocks.ice);
                }
            }
        }
        return par1ItemStack;
    }

    @Override
    public ItemStack onEnvironmentalRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        int radius = 3;
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    Block block = par2World.getBlock((int)par3EntityPlayer.posX + i - 1, (int)par3EntityPlayer.posY + j, (int)par3EntityPlayer.posZ + k);
                    if (block != Blocks.water && block != Blocks.flowing_water) continue;
                    par2World.setBlock((int)par3EntityPlayer.posX + i - 1, (int)par3EntityPlayer.posY + j, (int)par3EntityPlayer.posZ + k, Blocks.ice);
                }
            }
        }
        return par1ItemStack;
    }
}

